package app.valuationcontrol.multimodule.library.xlhandler;

import java.io.InputStream;

public interface CalcDocument {

  /**
   * @param resetRunnable the function to reset document
   */
  default void assertConnected(Runnable resetRunnable) {}

  GenericSheet getSheet(SCENARIO scenario);

  GenericSheet createPrettySheet(String name);

  @SuppressWarnings("EmptyMethod")
  void preventScreenUpdating(boolean prevent);

  void close();

  InputStream saveAs();

  void remove(GenericSheet genericSheet);

  GenericSheet copy(GenericSheet sourceGenericSheet, String newSheetName);

  void closeAllSheets();

  void closeAllButBase();
}
