/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.entities;

import app.valuationcontrol.multimodule.library.entities.Model;
import app.valuationcontrol.multimodule.library.entities.Sensitivity;
import app.valuationcontrol.multimodule.library.helpers.PercentageFloatDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import java.util.Map;
import java.util.function.IntConsumer;
import lombok.Generated;

@Embeddable
public class KeyParam {
    @Column(name="keyoutput_1_id")
    private Long keyOutput1Id;
    @Column(name="keyoutput_2_id")
    private Long keyOutput2Id;
    @Column(name="keyoutput_1_period")
    private Integer keyOutput1Period;
    @Column(name="keyoutput_2_period")
    private Integer keyOutput2Period;
    @Column(name="keyparam_1_id")
    private Long keyParam1Id;
    @Column(name="keyparam_1_period")
    private Integer keyParam1Period;
    @Column(name="keyparam_1_type")
    private String keyParam1Type;
    @Column(name="keyparam_1_start_value")
    @JsonDeserialize(using=PercentageFloatDeserializer.class)
    private Float keyParam1StartValue;
    @Column(name="keyparam_1_stop_value")
    @JsonDeserialize(using=PercentageFloatDeserializer.class)
    private Float keyParam1StopValue;
    @Column(name="keyparam_2_id")
    private Long keyParam2Id;
    @Column(name="keyparam_2_period")
    private Integer keyParam2Period;
    @Column(name="keyparam_2_type")
    private String keyParam2Type;
    @Column(name="keyparam_2_start_value")
    @JsonDeserialize(using=PercentageFloatDeserializer.class)
    private Float keyParam2StartValue;
    @Column(name="keyparam_2_stop_value")
    @JsonDeserialize(using=PercentageFloatDeserializer.class)
    private Float keyParam2StopValue;
    @Column(name="keyparam_3_id")
    private Long keyParam3Id;
    @Column(name="keyparam_3_period")
    private Integer keyParam3Period;
    @Column(name="keyparam_3_type")
    private String keyParam3Type;
    @Column(name="keyparam_3_start_value")
    @JsonDeserialize(using=PercentageFloatDeserializer.class)
    private Float keyParam3StartValue;
    @Column(name="keyparam_3_stop_value")
    @JsonDeserialize(using=PercentageFloatDeserializer.class)
    private Float keyParam3StopValue;
    @Column(name="keyparam_4_id")
    private Long keyParam4Id;
    @Column(name="keyparam_4_period")
    private Integer keyParam4Period;
    @Column(name="keyparam_4_type")
    private String keyParam4Type;
    @Column(name="keyparam_4_start_value")
    @JsonDeserialize(using=PercentageFloatDeserializer.class)
    private Float keyParam4StartValue;
    @Column(name="keyparam_4_stop_value")
    @JsonDeserialize(using=PercentageFloatDeserializer.class)
    private Float keyParam4StopValue;

    public void copyFromExisting(KeyParam keyParam, Model model) {
        if (keyParam == null) {
            return;
        }
        this.smartSet(keyParam.getKeyOutput1Period(), this::setKeyOutput1Period, model);
        this.smartSet(keyParam.getKeyOutput2Period(), this::setKeyOutput2Period, model);
        this.smartSet(keyParam.getKeyParam1Period(), this::setKeyParam1Period, model);
        this.smartSet(keyParam.getKeyParam2Period(), this::setKeyParam2Period, model);
        this.smartSet(keyParam.getKeyParam3Period(), this::setKeyParam3Period, model);
        this.smartSet(keyParam.getKeyParam4Period(), this::setKeyParam4Period, model);
        this.keyOutput1Id = keyParam.getKeyOutput1Id();
        this.keyOutput2Id = keyParam.getKeyOutput2Id();
        this.keyParam1Id = keyParam.getKeyParam1Id();
        this.keyParam2Id = keyParam.getKeyParam2Id();
        this.keyParam3Id = keyParam.getKeyParam3Id();
        this.keyParam4Id = keyParam.getKeyParam4Id();
        this.keyParam1StartValue = keyParam.getKeyParam1StartValue();
        this.keyParam2StartValue = keyParam.getKeyParam2StartValue();
        this.keyParam3StartValue = keyParam.getKeyParam3StartValue();
        this.keyParam4StartValue = keyParam.getKeyParam4StartValue();
        this.keyParam1StopValue = keyParam.getKeyParam1StopValue();
        this.keyParam2StopValue = keyParam.getKeyParam2StopValue();
        this.keyParam3StopValue = keyParam.getKeyParam3StopValue();
        this.keyParam4StopValue = keyParam.getKeyParam4StopValue();
        this.keyParam1Type = keyParam.getKeyParam1Type();
        this.keyParam2Type = keyParam.getKeyParam2Type();
        this.keyParam3Type = keyParam.getKeyParam3Type();
        this.keyParam4Type = keyParam.getKeyParam4Type();
    }

    private void smartSet(Integer period, IntConsumer setPeriod, Model model) {
        block4: {
            Integer modelYear = Sensitivity.asModelYear(period, model);
            try {
                Integer yearIndex = Sensitivity.fromYear(modelYear, model);
                if (yearIndex != null) {
                    setPeriod.accept(yearIndex);
                }
            }
            catch (IllegalArgumentException e) {
                if (period < -model.getNbHistoricalPeriod().intValue()) {
                    setPeriod.accept(-model.getNbHistoricalPeriod().intValue());
                }
                if (period <= model.getNbProjectionPeriod() - 1) break block4;
                setPeriod.accept(model.getNbProjectionPeriod() - 1);
            }
        }
    }

    public void replaceIds(Map<Long, Long> oldToNewIds) {
        this.keyOutput1Id = oldToNewIds.get(this.keyOutput1Id);
        this.keyOutput2Id = oldToNewIds.get(this.keyOutput2Id);
        this.keyParam1Id = oldToNewIds.get(this.keyParam1Id);
        this.keyParam2Id = oldToNewIds.get(this.keyParam2Id);
        this.keyParam3Id = oldToNewIds.get(this.keyParam3Id);
        this.keyParam4Id = oldToNewIds.get(this.keyParam4Id);
    }

    public void deleteVariableFromKeyParam(Long variableId) {
        if (variableId == null) {
            return;
        }
        if (variableId.equals(this.keyOutput1Id)) {
            this.keyOutput1Id = null;
            this.keyOutput1Period = null;
        }
        if (variableId.equals(this.keyOutput2Id)) {
            this.keyOutput2Id = null;
            this.keyOutput2Period = null;
        }
        if (variableId.equals(this.keyParam1Id)) {
            this.keyParam1Id = null;
            this.keyParam1Period = null;
            this.keyParam1StartValue = null;
            this.keyParam1StopValue = null;
            this.keyParam1Type = null;
        }
        if (variableId.equals(this.keyParam2Id)) {
            this.keyParam2Id = null;
            this.keyParam2Period = null;
            this.keyParam2StartValue = null;
            this.keyParam2StopValue = null;
            this.keyParam2Type = null;
        }
        if (variableId.equals(this.keyParam3Id)) {
            this.keyParam3Id = null;
            this.keyParam3Period = null;
            this.keyParam3StartValue = null;
            this.keyParam3StopValue = null;
            this.keyParam3Type = null;
        }
        if (variableId.equals(this.keyParam4Id)) {
            this.keyParam4Id = null;
            this.keyParam4Period = null;
            this.keyParam4StartValue = null;
            this.keyParam4StopValue = null;
            this.keyParam4Type = null;
        }
    }

    @Generated
    public KeyParam() {
    }

    @Generated
    public Long getKeyOutput1Id() {
        return this.keyOutput1Id;
    }

    @Generated
    public Long getKeyOutput2Id() {
        return this.keyOutput2Id;
    }

    @Generated
    public Integer getKeyOutput1Period() {
        return this.keyOutput1Period;
    }

    @Generated
    public Integer getKeyOutput2Period() {
        return this.keyOutput2Period;
    }

    @Generated
    public Long getKeyParam1Id() {
        return this.keyParam1Id;
    }

    @Generated
    public Integer getKeyParam1Period() {
        return this.keyParam1Period;
    }

    @Generated
    public String getKeyParam1Type() {
        return this.keyParam1Type;
    }

    @Generated
    public Float getKeyParam1StartValue() {
        return this.keyParam1StartValue;
    }

    @Generated
    public Float getKeyParam1StopValue() {
        return this.keyParam1StopValue;
    }

    @Generated
    public Long getKeyParam2Id() {
        return this.keyParam2Id;
    }

    @Generated
    public Integer getKeyParam2Period() {
        return this.keyParam2Period;
    }

    @Generated
    public String getKeyParam2Type() {
        return this.keyParam2Type;
    }

    @Generated
    public Float getKeyParam2StartValue() {
        return this.keyParam2StartValue;
    }

    @Generated
    public Float getKeyParam2StopValue() {
        return this.keyParam2StopValue;
    }

    @Generated
    public Long getKeyParam3Id() {
        return this.keyParam3Id;
    }

    @Generated
    public Integer getKeyParam3Period() {
        return this.keyParam3Period;
    }

    @Generated
    public String getKeyParam3Type() {
        return this.keyParam3Type;
    }

    @Generated
    public Float getKeyParam3StartValue() {
        return this.keyParam3StartValue;
    }

    @Generated
    public Float getKeyParam3StopValue() {
        return this.keyParam3StopValue;
    }

    @Generated
    public Long getKeyParam4Id() {
        return this.keyParam4Id;
    }

    @Generated
    public Integer getKeyParam4Period() {
        return this.keyParam4Period;
    }

    @Generated
    public String getKeyParam4Type() {
        return this.keyParam4Type;
    }

    @Generated
    public Float getKeyParam4StartValue() {
        return this.keyParam4StartValue;
    }

    @Generated
    public Float getKeyParam4StopValue() {
        return this.keyParam4StopValue;
    }

    @Generated
    public void setKeyOutput1Id(Long keyOutput1Id) {
        this.keyOutput1Id = keyOutput1Id;
    }

    @Generated
    public void setKeyOutput2Id(Long keyOutput2Id) {
        this.keyOutput2Id = keyOutput2Id;
    }

    @Generated
    public void setKeyOutput1Period(Integer keyOutput1Period) {
        this.keyOutput1Period = keyOutput1Period;
    }

    @Generated
    public void setKeyOutput2Period(Integer keyOutput2Period) {
        this.keyOutput2Period = keyOutput2Period;
    }

    @Generated
    public void setKeyParam1Id(Long keyParam1Id) {
        this.keyParam1Id = keyParam1Id;
    }

    @Generated
    public void setKeyParam1Period(Integer keyParam1Period) {
        this.keyParam1Period = keyParam1Period;
    }

    @Generated
    public void setKeyParam1Type(String keyParam1Type) {
        this.keyParam1Type = keyParam1Type;
    }

    @JsonDeserialize(using=PercentageFloatDeserializer.class)
    @Generated
    public void setKeyParam1StartValue(Float keyParam1StartValue) {
        this.keyParam1StartValue = keyParam1StartValue;
    }

    @JsonDeserialize(using=PercentageFloatDeserializer.class)
    @Generated
    public void setKeyParam1StopValue(Float keyParam1StopValue) {
        this.keyParam1StopValue = keyParam1StopValue;
    }

    @Generated
    public void setKeyParam2Id(Long keyParam2Id) {
        this.keyParam2Id = keyParam2Id;
    }

    @Generated
    public void setKeyParam2Period(Integer keyParam2Period) {
        this.keyParam2Period = keyParam2Period;
    }

    @Generated
    public void setKeyParam2Type(String keyParam2Type) {
        this.keyParam2Type = keyParam2Type;
    }

    @JsonDeserialize(using=PercentageFloatDeserializer.class)
    @Generated
    public void setKeyParam2StartValue(Float keyParam2StartValue) {
        this.keyParam2StartValue = keyParam2StartValue;
    }

    @JsonDeserialize(using=PercentageFloatDeserializer.class)
    @Generated
    public void setKeyParam2StopValue(Float keyParam2StopValue) {
        this.keyParam2StopValue = keyParam2StopValue;
    }

    @Generated
    public void setKeyParam3Id(Long keyParam3Id) {
        this.keyParam3Id = keyParam3Id;
    }

    @Generated
    public void setKeyParam3Period(Integer keyParam3Period) {
        this.keyParam3Period = keyParam3Period;
    }

    @Generated
    public void setKeyParam3Type(String keyParam3Type) {
        this.keyParam3Type = keyParam3Type;
    }

    @JsonDeserialize(using=PercentageFloatDeserializer.class)
    @Generated
    public void setKeyParam3StartValue(Float keyParam3StartValue) {
        this.keyParam3StartValue = keyParam3StartValue;
    }

    @JsonDeserialize(using=PercentageFloatDeserializer.class)
    @Generated
    public void setKeyParam3StopValue(Float keyParam3StopValue) {
        this.keyParam3StopValue = keyParam3StopValue;
    }

    @Generated
    public void setKeyParam4Id(Long keyParam4Id) {
        this.keyParam4Id = keyParam4Id;
    }

    @Generated
    public void setKeyParam4Period(Integer keyParam4Period) {
        this.keyParam4Period = keyParam4Period;
    }

    @Generated
    public void setKeyParam4Type(String keyParam4Type) {
        this.keyParam4Type = keyParam4Type;
    }

    @JsonDeserialize(using=PercentageFloatDeserializer.class)
    @Generated
    public void setKeyParam4StartValue(Float keyParam4StartValue) {
        this.keyParam4StartValue = keyParam4StartValue;
    }

    @JsonDeserialize(using=PercentageFloatDeserializer.class)
    @Generated
    public void setKeyParam4StopValue(Float keyParam4StopValue) {
        this.keyParam4StopValue = keyParam4StopValue;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyParam)) {
            return false;
        }
        KeyParam other = (KeyParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$keyOutput1Id = this.getKeyOutput1Id();
        Long other$keyOutput1Id = other.getKeyOutput1Id();
        if (this$keyOutput1Id == null ? other$keyOutput1Id != null : !((Object)this$keyOutput1Id).equals(other$keyOutput1Id)) {
            return false;
        }
        Long this$keyOutput2Id = this.getKeyOutput2Id();
        Long other$keyOutput2Id = other.getKeyOutput2Id();
        if (this$keyOutput2Id == null ? other$keyOutput2Id != null : !((Object)this$keyOutput2Id).equals(other$keyOutput2Id)) {
            return false;
        }
        Integer this$keyOutput1Period = this.getKeyOutput1Period();
        Integer other$keyOutput1Period = other.getKeyOutput1Period();
        if (this$keyOutput1Period == null ? other$keyOutput1Period != null : !((Object)this$keyOutput1Period).equals(other$keyOutput1Period)) {
            return false;
        }
        Integer this$keyOutput2Period = this.getKeyOutput2Period();
        Integer other$keyOutput2Period = other.getKeyOutput2Period();
        if (this$keyOutput2Period == null ? other$keyOutput2Period != null : !((Object)this$keyOutput2Period).equals(other$keyOutput2Period)) {
            return false;
        }
        Long this$keyParam1Id = this.getKeyParam1Id();
        Long other$keyParam1Id = other.getKeyParam1Id();
        if (this$keyParam1Id == null ? other$keyParam1Id != null : !((Object)this$keyParam1Id).equals(other$keyParam1Id)) {
            return false;
        }
        Integer this$keyParam1Period = this.getKeyParam1Period();
        Integer other$keyParam1Period = other.getKeyParam1Period();
        if (this$keyParam1Period == null ? other$keyParam1Period != null : !((Object)this$keyParam1Period).equals(other$keyParam1Period)) {
            return false;
        }
        Float this$keyParam1StartValue = this.getKeyParam1StartValue();
        Float other$keyParam1StartValue = other.getKeyParam1StartValue();
        if (this$keyParam1StartValue == null ? other$keyParam1StartValue != null : !((Object)this$keyParam1StartValue).equals(other$keyParam1StartValue)) {
            return false;
        }
        Float this$keyParam1StopValue = this.getKeyParam1StopValue();
        Float other$keyParam1StopValue = other.getKeyParam1StopValue();
        if (this$keyParam1StopValue == null ? other$keyParam1StopValue != null : !((Object)this$keyParam1StopValue).equals(other$keyParam1StopValue)) {
            return false;
        }
        Long this$keyParam2Id = this.getKeyParam2Id();
        Long other$keyParam2Id = other.getKeyParam2Id();
        if (this$keyParam2Id == null ? other$keyParam2Id != null : !((Object)this$keyParam2Id).equals(other$keyParam2Id)) {
            return false;
        }
        Integer this$keyParam2Period = this.getKeyParam2Period();
        Integer other$keyParam2Period = other.getKeyParam2Period();
        if (this$keyParam2Period == null ? other$keyParam2Period != null : !((Object)this$keyParam2Period).equals(other$keyParam2Period)) {
            return false;
        }
        Float this$keyParam2StartValue = this.getKeyParam2StartValue();
        Float other$keyParam2StartValue = other.getKeyParam2StartValue();
        if (this$keyParam2StartValue == null ? other$keyParam2StartValue != null : !((Object)this$keyParam2StartValue).equals(other$keyParam2StartValue)) {
            return false;
        }
        Float this$keyParam2StopValue = this.getKeyParam2StopValue();
        Float other$keyParam2StopValue = other.getKeyParam2StopValue();
        if (this$keyParam2StopValue == null ? other$keyParam2StopValue != null : !((Object)this$keyParam2StopValue).equals(other$keyParam2StopValue)) {
            return false;
        }
        Long this$keyParam3Id = this.getKeyParam3Id();
        Long other$keyParam3Id = other.getKeyParam3Id();
        if (this$keyParam3Id == null ? other$keyParam3Id != null : !((Object)this$keyParam3Id).equals(other$keyParam3Id)) {
            return false;
        }
        Integer this$keyParam3Period = this.getKeyParam3Period();
        Integer other$keyParam3Period = other.getKeyParam3Period();
        if (this$keyParam3Period == null ? other$keyParam3Period != null : !((Object)this$keyParam3Period).equals(other$keyParam3Period)) {
            return false;
        }
        Float this$keyParam3StartValue = this.getKeyParam3StartValue();
        Float other$keyParam3StartValue = other.getKeyParam3StartValue();
        if (this$keyParam3StartValue == null ? other$keyParam3StartValue != null : !((Object)this$keyParam3StartValue).equals(other$keyParam3StartValue)) {
            return false;
        }
        Float this$keyParam3StopValue = this.getKeyParam3StopValue();
        Float other$keyParam3StopValue = other.getKeyParam3StopValue();
        if (this$keyParam3StopValue == null ? other$keyParam3StopValue != null : !((Object)this$keyParam3StopValue).equals(other$keyParam3StopValue)) {
            return false;
        }
        Long this$keyParam4Id = this.getKeyParam4Id();
        Long other$keyParam4Id = other.getKeyParam4Id();
        if (this$keyParam4Id == null ? other$keyParam4Id != null : !((Object)this$keyParam4Id).equals(other$keyParam4Id)) {
            return false;
        }
        Integer this$keyParam4Period = this.getKeyParam4Period();
        Integer other$keyParam4Period = other.getKeyParam4Period();
        if (this$keyParam4Period == null ? other$keyParam4Period != null : !((Object)this$keyParam4Period).equals(other$keyParam4Period)) {
            return false;
        }
        Float this$keyParam4StartValue = this.getKeyParam4StartValue();
        Float other$keyParam4StartValue = other.getKeyParam4StartValue();
        if (this$keyParam4StartValue == null ? other$keyParam4StartValue != null : !((Object)this$keyParam4StartValue).equals(other$keyParam4StartValue)) {
            return false;
        }
        Float this$keyParam4StopValue = this.getKeyParam4StopValue();
        Float other$keyParam4StopValue = other.getKeyParam4StopValue();
        if (this$keyParam4StopValue == null ? other$keyParam4StopValue != null : !((Object)this$keyParam4StopValue).equals(other$keyParam4StopValue)) {
            return false;
        }
        String this$keyParam1Type = this.getKeyParam1Type();
        String other$keyParam1Type = other.getKeyParam1Type();
        if (this$keyParam1Type == null ? other$keyParam1Type != null : !this$keyParam1Type.equals(other$keyParam1Type)) {
            return false;
        }
        String this$keyParam2Type = this.getKeyParam2Type();
        String other$keyParam2Type = other.getKeyParam2Type();
        if (this$keyParam2Type == null ? other$keyParam2Type != null : !this$keyParam2Type.equals(other$keyParam2Type)) {
            return false;
        }
        String this$keyParam3Type = this.getKeyParam3Type();
        String other$keyParam3Type = other.getKeyParam3Type();
        if (this$keyParam3Type == null ? other$keyParam3Type != null : !this$keyParam3Type.equals(other$keyParam3Type)) {
            return false;
        }
        String this$keyParam4Type = this.getKeyParam4Type();
        String other$keyParam4Type = other.getKeyParam4Type();
        return !(this$keyParam4Type == null ? other$keyParam4Type != null : !this$keyParam4Type.equals(other$keyParam4Type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KeyParam;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $keyOutput1Id = this.getKeyOutput1Id();
        result = result * 59 + ($keyOutput1Id == null ? 43 : ((Object)$keyOutput1Id).hashCode());
        Long $keyOutput2Id = this.getKeyOutput2Id();
        result = result * 59 + ($keyOutput2Id == null ? 43 : ((Object)$keyOutput2Id).hashCode());
        Integer $keyOutput1Period = this.getKeyOutput1Period();
        result = result * 59 + ($keyOutput1Period == null ? 43 : ((Object)$keyOutput1Period).hashCode());
        Integer $keyOutput2Period = this.getKeyOutput2Period();
        result = result * 59 + ($keyOutput2Period == null ? 43 : ((Object)$keyOutput2Period).hashCode());
        Long $keyParam1Id = this.getKeyParam1Id();
        result = result * 59 + ($keyParam1Id == null ? 43 : ((Object)$keyParam1Id).hashCode());
        Integer $keyParam1Period = this.getKeyParam1Period();
        result = result * 59 + ($keyParam1Period == null ? 43 : ((Object)$keyParam1Period).hashCode());
        Float $keyParam1StartValue = this.getKeyParam1StartValue();
        result = result * 59 + ($keyParam1StartValue == null ? 43 : ((Object)$keyParam1StartValue).hashCode());
        Float $keyParam1StopValue = this.getKeyParam1StopValue();
        result = result * 59 + ($keyParam1StopValue == null ? 43 : ((Object)$keyParam1StopValue).hashCode());
        Long $keyParam2Id = this.getKeyParam2Id();
        result = result * 59 + ($keyParam2Id == null ? 43 : ((Object)$keyParam2Id).hashCode());
        Integer $keyParam2Period = this.getKeyParam2Period();
        result = result * 59 + ($keyParam2Period == null ? 43 : ((Object)$keyParam2Period).hashCode());
        Float $keyParam2StartValue = this.getKeyParam2StartValue();
        result = result * 59 + ($keyParam2StartValue == null ? 43 : ((Object)$keyParam2StartValue).hashCode());
        Float $keyParam2StopValue = this.getKeyParam2StopValue();
        result = result * 59 + ($keyParam2StopValue == null ? 43 : ((Object)$keyParam2StopValue).hashCode());
        Long $keyParam3Id = this.getKeyParam3Id();
        result = result * 59 + ($keyParam3Id == null ? 43 : ((Object)$keyParam3Id).hashCode());
        Integer $keyParam3Period = this.getKeyParam3Period();
        result = result * 59 + ($keyParam3Period == null ? 43 : ((Object)$keyParam3Period).hashCode());
        Float $keyParam3StartValue = this.getKeyParam3StartValue();
        result = result * 59 + ($keyParam3StartValue == null ? 43 : ((Object)$keyParam3StartValue).hashCode());
        Float $keyParam3StopValue = this.getKeyParam3StopValue();
        result = result * 59 + ($keyParam3StopValue == null ? 43 : ((Object)$keyParam3StopValue).hashCode());
        Long $keyParam4Id = this.getKeyParam4Id();
        result = result * 59 + ($keyParam4Id == null ? 43 : ((Object)$keyParam4Id).hashCode());
        Integer $keyParam4Period = this.getKeyParam4Period();
        result = result * 59 + ($keyParam4Period == null ? 43 : ((Object)$keyParam4Period).hashCode());
        Float $keyParam4StartValue = this.getKeyParam4StartValue();
        result = result * 59 + ($keyParam4StartValue == null ? 43 : ((Object)$keyParam4StartValue).hashCode());
        Float $keyParam4StopValue = this.getKeyParam4StopValue();
        result = result * 59 + ($keyParam4StopValue == null ? 43 : ((Object)$keyParam4StopValue).hashCode());
        String $keyParam1Type = this.getKeyParam1Type();
        result = result * 59 + ($keyParam1Type == null ? 43 : $keyParam1Type.hashCode());
        String $keyParam2Type = this.getKeyParam2Type();
        result = result * 59 + ($keyParam2Type == null ? 43 : $keyParam2Type.hashCode());
        String $keyParam3Type = this.getKeyParam3Type();
        result = result * 59 + ($keyParam3Type == null ? 43 : $keyParam3Type.hashCode());
        String $keyParam4Type = this.getKeyParam4Type();
        result = result * 59 + ($keyParam4Type == null ? 43 : $keyParam4Type.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "KeyParam(keyOutput1Id=" + this.getKeyOutput1Id() + ", keyOutput2Id=" + this.getKeyOutput2Id() + ", keyOutput1Period=" + this.getKeyOutput1Period() + ", keyOutput2Period=" + this.getKeyOutput2Period() + ", keyParam1Id=" + this.getKeyParam1Id() + ", keyParam1Period=" + this.getKeyParam1Period() + ", keyParam1Type=" + this.getKeyParam1Type() + ", keyParam1StartValue=" + this.getKeyParam1StartValue() + ", keyParam1StopValue=" + this.getKeyParam1StopValue() + ", keyParam2Id=" + this.getKeyParam2Id() + ", keyParam2Period=" + this.getKeyParam2Period() + ", keyParam2Type=" + this.getKeyParam2Type() + ", keyParam2StartValue=" + this.getKeyParam2StartValue() + ", keyParam2StopValue=" + this.getKeyParam2StopValue() + ", keyParam3Id=" + this.getKeyParam3Id() + ", keyParam3Period=" + this.getKeyParam3Period() + ", keyParam3Type=" + this.getKeyParam3Type() + ", keyParam3StartValue=" + this.getKeyParam3StartValue() + ", keyParam3StopValue=" + this.getKeyParam3StopValue() + ", keyParam4Id=" + this.getKeyParam4Id() + ", keyParam4Period=" + this.getKeyParam4Period() + ", keyParam4Type=" + this.getKeyParam4Type() + ", keyParam4StartValue=" + this.getKeyParam4StartValue() + ", keyParam4StopValue=" + this.getKeyParam4StopValue() + ")";
    }
}

