/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.entities;

import app.valuationcontrol.multimodule.library.entities.Model;
import app.valuationcontrol.multimodule.library.helpers.DataTransformer;
import app.valuationcontrol.multimodule.library.helpers.LogEntryNotifier;
import app.valuationcontrol.multimodule.library.records.LogEntryData;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import java.time.LocalDateTime;
import lombok.Generated;

@Entity
@EntityListeners(value={LogEntryNotifier.class})
public class LogEntry
implements DataTransformer<LogEntryData> {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    @ManyToOne
    private Model attachedModel;
    private String action;
    private String username;
    private Boolean isModelChange;
    @Column(length=500)
    private String fromFormula;
    @Column(length=500)
    private String toFormula;
    private Float fromValue;
    private Float toValue;
    private LocalDateTime changeDate;
    private Integer period;
    private Long variableId;

    public LogEntry() {
    }

    @Override
    public LogEntryData asData() {
        return new LogEntryData(this.id, this.action, this.username, this.isModelChange, this.fromFormula, this.toFormula, this.fromValue, this.toValue, this.changeDate, this.period, this.variableId);
    }

    @Generated
    public static LogEntryBuilder builder() {
        return new LogEntryBuilder();
    }

    @Generated
    public LogEntry(long id, Model attachedModel, String action, String username, Boolean isModelChange, String fromFormula, String toFormula, Float fromValue, Float toValue, LocalDateTime changeDate, Integer period, Long variableId) {
        this.id = id;
        this.attachedModel = attachedModel;
        this.action = action;
        this.username = username;
        this.isModelChange = isModelChange;
        this.fromFormula = fromFormula;
        this.toFormula = toFormula;
        this.fromValue = fromValue;
        this.toValue = toValue;
        this.changeDate = changeDate;
        this.period = period;
        this.variableId = variableId;
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public Model getAttachedModel() {
        return this.attachedModel;
    }

    @Generated
    public String getAction() {
        return this.action;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public Boolean getIsModelChange() {
        return this.isModelChange;
    }

    @Generated
    public String getFromFormula() {
        return this.fromFormula;
    }

    @Generated
    public String getToFormula() {
        return this.toFormula;
    }

    @Generated
    public Float getFromValue() {
        return this.fromValue;
    }

    @Generated
    public Float getToValue() {
        return this.toValue;
    }

    @Generated
    public LocalDateTime getChangeDate() {
        return this.changeDate;
    }

    @Generated
    public Integer getPeriod() {
        return this.period;
    }

    @Generated
    public Long getVariableId() {
        return this.variableId;
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setAttachedModel(Model attachedModel) {
        this.attachedModel = attachedModel;
    }

    @Generated
    public void setAction(String action) {
        this.action = action;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setIsModelChange(Boolean isModelChange) {
        this.isModelChange = isModelChange;
    }

    @Generated
    public void setFromFormula(String fromFormula) {
        this.fromFormula = fromFormula;
    }

    @Generated
    public void setToFormula(String toFormula) {
        this.toFormula = toFormula;
    }

    @Generated
    public void setFromValue(Float fromValue) {
        this.fromValue = fromValue;
    }

    @Generated
    public void setToValue(Float toValue) {
        this.toValue = toValue;
    }

    @Generated
    public void setChangeDate(LocalDateTime changeDate) {
        this.changeDate = changeDate;
    }

    @Generated
    public void setPeriod(Integer period) {
        this.period = period;
    }

    @Generated
    public void setVariableId(Long variableId) {
        this.variableId = variableId;
    }

    @Generated
    public static class LogEntryBuilder {
        @Generated
        private long id;
        @Generated
        private Model attachedModel;
        @Generated
        private String action;
        @Generated
        private String username;
        @Generated
        private Boolean isModelChange;
        @Generated
        private String fromFormula;
        @Generated
        private String toFormula;
        @Generated
        private Float fromValue;
        @Generated
        private Float toValue;
        @Generated
        private LocalDateTime changeDate;
        @Generated
        private Integer period;
        @Generated
        private Long variableId;

        @Generated
        LogEntryBuilder() {
        }

        @Generated
        public LogEntryBuilder id(long id) {
            this.id = id;
            return this;
        }

        @Generated
        public LogEntryBuilder attachedModel(Model attachedModel) {
            this.attachedModel = attachedModel;
            return this;
        }

        @Generated
        public LogEntryBuilder action(String action) {
            this.action = action;
            return this;
        }

        @Generated
        public LogEntryBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public LogEntryBuilder isModelChange(Boolean isModelChange) {
            this.isModelChange = isModelChange;
            return this;
        }

        @Generated
        public LogEntryBuilder fromFormula(String fromFormula) {
            this.fromFormula = fromFormula;
            return this;
        }

        @Generated
        public LogEntryBuilder toFormula(String toFormula) {
            this.toFormula = toFormula;
            return this;
        }

        @Generated
        public LogEntryBuilder fromValue(Float fromValue) {
            this.fromValue = fromValue;
            return this;
        }

        @Generated
        public LogEntryBuilder toValue(Float toValue) {
            this.toValue = toValue;
            return this;
        }

        @Generated
        public LogEntryBuilder changeDate(LocalDateTime changeDate) {
            this.changeDate = changeDate;
            return this;
        }

        @Generated
        public LogEntryBuilder period(Integer period) {
            this.period = period;
            return this;
        }

        @Generated
        public LogEntryBuilder variableId(Long variableId) {
            this.variableId = variableId;
            return this;
        }

        @Generated
        public LogEntry build() {
            return new LogEntry(this.id, this.attachedModel, this.action, this.username, this.isModelChange, this.fromFormula, this.toFormula, this.fromValue, this.toValue, this.changeDate, this.period, this.variableId);
        }

        @Generated
        public String toString() {
            return "LogEntry.LogEntryBuilder(id=" + this.id + ", attachedModel=" + String.valueOf(this.attachedModel) + ", action=" + this.action + ", username=" + this.username + ", isModelChange=" + this.isModelChange + ", fromFormula=" + this.fromFormula + ", toFormula=" + this.toFormula + ", fromValue=" + this.fromValue + ", toValue=" + this.toValue + ", changeDate=" + String.valueOf(this.changeDate) + ", period=" + this.period + ", variableId=" + this.variableId + ")";
        }
    }
}

