/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.entities;

import app.valuationcontrol.multimodule.library.entities.Model;
import app.valuationcontrol.multimodule.library.helpers.DataTransformer;
import app.valuationcontrol.multimodule.library.helpers.ModelProvider;
import app.valuationcontrol.multimodule.library.records.SensitivityData;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import java.time.LocalDateTime;
import lombok.Generated;

@Entity
public class Sensitivity
implements DataTransformer<SensitivityData>,
ModelProvider {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne
    private Model attachedModel;
    private String sensitivityName;
    private String sensitivityDescription;
    private Long sensitivityVariable1Id;
    private Long sensitivityVariable2Id;
    private Long sensitivityMeasurementVariableId;
    private Integer sensitivityVariable1Period;
    private Integer sensitivityVariable2Period;
    private Integer sensitivityMeasurementVariablePeriod;
    private Integer sensitivityVariable1Steps;
    private Integer sensitivityVariable2Steps;
    private Float sensitivityVariable1StepSize;
    private Float sensitivityVariable2StepSize;
    private LocalDateTime sensitivityLastRun;

    public Sensitivity(Sensitivity sensitivity) {
        this(sensitivity.asData(), sensitivity.getAttachedModel());
        this.id = sensitivity.id;
    }

    public Sensitivity(SensitivityData sensitivityData, Model model) {
        this.attachedModel = model;
        this.updateWith(sensitivityData);
    }

    public static Integer fromYear(Integer year, Model model) {
        if (year == null) {
            return null;
        }
        int yearIndex = year - model.getStartYear();
        if (yearIndex + model.getNbHistoricalPeriod() < 0 || yearIndex - model.getNbProjectionPeriod() > 0) {
            throw new IllegalArgumentException("Year: " + year + " is outside of the model (" + (model.getStartYear() - model.getNbHistoricalPeriod()) + " - " + (model.getStartYear() + model.getNbProjectionPeriod()) + ")");
        }
        return yearIndex;
    }

    public Sensitivity() {
    }

    @Override
    public SensitivityData asData() {
        return new SensitivityData(this.id, this.sensitivityName, this.sensitivityDescription, this.sensitivityVariable1Id, this.sensitivityVariable2Id, this.sensitivityMeasurementVariableId, Sensitivity.asModelYear(this.sensitivityVariable1Period, this.getAttachedModel()), Sensitivity.asModelYear(this.sensitivityVariable2Period, this.getAttachedModel()), Sensitivity.asModelYear(this.sensitivityMeasurementVariablePeriod, this.getAttachedModel()), this.sensitivityVariable1Steps, this.sensitivityVariable2Steps, this.sensitivityVariable1StepSize, this.sensitivityVariable2StepSize, this.sensitivityLastRun);
    }

    public static Integer asModelYear(Integer indexedPeriod, Model model) {
        if (indexedPeriod != null && indexedPeriod > model.getNbProjectionPeriod()) {
            return indexedPeriod;
        }
        return Sensitivity.asModelYear(indexedPeriod, model.getStartYear());
    }

    public static Integer asModelYear(Integer indexedPeriod, Integer startYear) {
        if (indexedPeriod == null) {
            return null;
        }
        return startYear + indexedPeriod;
    }

    @Override
    public Long getModelId() {
        return this.getAttachedModel().getId();
    }

    public void updateWith(SensitivityData sensitivityData) {
        this.sensitivityName = sensitivityData.name();
        this.sensitivityDescription = sensitivityData.description();
        this.sensitivityVariable1Id = sensitivityData.variable1Id();
        this.sensitivityVariable2Id = sensitivityData.variable2Id();
        this.sensitivityMeasurementVariableId = sensitivityData.measurementVariableId();
        this.sensitivityVariable1Period = Sensitivity.fromYear(sensitivityData.variable1Period(), this.attachedModel);
        this.sensitivityVariable2Period = Sensitivity.fromYear(sensitivityData.variable2Period(), this.attachedModel);
        this.sensitivityMeasurementVariablePeriod = Sensitivity.fromYear(sensitivityData.measurementVariablePeriod(), this.attachedModel);
        this.sensitivityVariable1Steps = sensitivityData.variable1Steps();
        this.sensitivityVariable2Steps = sensitivityData.variable2Steps();
        this.sensitivityVariable1StepSize = sensitivityData.variable1StepSize();
        this.sensitivityVariable2StepSize = sensitivityData.variable2StepSize();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Model getAttachedModel() {
        return this.attachedModel;
    }

    @Generated
    public String getSensitivityName() {
        return this.sensitivityName;
    }

    @Generated
    public String getSensitivityDescription() {
        return this.sensitivityDescription;
    }

    @Generated
    public Long getSensitivityVariable1Id() {
        return this.sensitivityVariable1Id;
    }

    @Generated
    public Long getSensitivityVariable2Id() {
        return this.sensitivityVariable2Id;
    }

    @Generated
    public Long getSensitivityMeasurementVariableId() {
        return this.sensitivityMeasurementVariableId;
    }

    @Generated
    public Integer getSensitivityVariable1Period() {
        return this.sensitivityVariable1Period;
    }

    @Generated
    public Integer getSensitivityVariable2Period() {
        return this.sensitivityVariable2Period;
    }

    @Generated
    public Integer getSensitivityMeasurementVariablePeriod() {
        return this.sensitivityMeasurementVariablePeriod;
    }

    @Generated
    public Integer getSensitivityVariable1Steps() {
        return this.sensitivityVariable1Steps;
    }

    @Generated
    public Integer getSensitivityVariable2Steps() {
        return this.sensitivityVariable2Steps;
    }

    @Generated
    public Float getSensitivityVariable1StepSize() {
        return this.sensitivityVariable1StepSize;
    }

    @Generated
    public Float getSensitivityVariable2StepSize() {
        return this.sensitivityVariable2StepSize;
    }

    @Generated
    public LocalDateTime getSensitivityLastRun() {
        return this.sensitivityLastRun;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setAttachedModel(Model attachedModel) {
        this.attachedModel = attachedModel;
    }

    @Generated
    public void setSensitivityVariable1Id(Long sensitivityVariable1Id) {
        this.sensitivityVariable1Id = sensitivityVariable1Id;
    }

    @Generated
    public void setSensitivityVariable2Id(Long sensitivityVariable2Id) {
        this.sensitivityVariable2Id = sensitivityVariable2Id;
    }

    @Generated
    public void setSensitivityMeasurementVariableId(Long sensitivityMeasurementVariableId) {
        this.sensitivityMeasurementVariableId = sensitivityMeasurementVariableId;
    }

    @Generated
    public void setSensitivityLastRun(LocalDateTime sensitivityLastRun) {
        this.sensitivityLastRun = sensitivityLastRun;
    }
}

