/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.entities;

import app.valuationcontrol.multimodule.library.entities.Area;
import app.valuationcontrol.multimodule.library.helpers.DataTransformer;
import app.valuationcontrol.multimodule.library.helpers.ModelProvider;
import app.valuationcontrol.multimodule.library.records.SubAreaData;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import java.util.OptionalInt;
import lombok.Generated;

@Entity
public class SubArea
implements DataTransformer<SubAreaData>,
ModelProvider {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    @ManyToOne
    private Area attachedArea;
    private String subAreaName;
    private String subAreaDescription;
    private boolean modelledAtSegment;
    private Integer subAreaOrder;

    public SubArea() {
    }

    public SubArea(SubArea subArea) {
        this(subArea.asData(), subArea.getAttachedArea());
        this.setSubAreaOrder(subArea.getSubAreaOrder());
    }

    public SubArea(SubAreaData subAreaData, Area area) {
        this.updateWith(subAreaData, area);
    }

    private int nextSubAreaOrder(Area area) {
        OptionalInt max = area.getSubAreas().stream().mapToInt(SubArea::getSubAreaOrder).max();
        return max.orElse(0) + 1;
    }

    @Override
    public SubAreaData asData() {
        return new SubAreaData(this.id, this.subAreaName, this.subAreaDescription, this.modelledAtSegment, this.subAreaOrder, this.attachedArea.getId());
    }

    public void updateWith(SubAreaData subAreaData, Area area) {
        this.setSubAreaName(subAreaData.subAreaName());
        this.setSubAreaDescription(subAreaData.subAreaDescription());
        this.setModelledAtSegment(Boolean.TRUE.equals(subAreaData.modelledAtSegment()));
        this.setAttachedArea(area);
        if (area.getSubAreas().stream().anyMatch(subArea -> subArea.id == this.id)) {
            this.setSubAreaOrder(subAreaData.subAreaOrder());
        } else {
            this.setSubAreaOrder(this.nextSubAreaOrder(area));
        }
    }

    @Override
    public Long getModelId() {
        return this.attachedArea.getModelId();
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public Area getAttachedArea() {
        return this.attachedArea;
    }

    @Generated
    public String getSubAreaName() {
        return this.subAreaName;
    }

    @Generated
    public String getSubAreaDescription() {
        return this.subAreaDescription;
    }

    @Generated
    public boolean isModelledAtSegment() {
        return this.modelledAtSegment;
    }

    @Generated
    public Integer getSubAreaOrder() {
        return this.subAreaOrder;
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setAttachedArea(Area attachedArea) {
        this.attachedArea = attachedArea;
    }

    @Generated
    public void setSubAreaName(String subAreaName) {
        this.subAreaName = subAreaName;
    }

    @Generated
    public void setSubAreaDescription(String subAreaDescription) {
        this.subAreaDescription = subAreaDescription;
    }

    @Generated
    public void setModelledAtSegment(boolean modelledAtSegment) {
        this.modelledAtSegment = modelledAtSegment;
    }

    @Generated
    public void setSubAreaOrder(Integer subAreaOrder) {
        this.subAreaOrder = subAreaOrder;
    }
}

