/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.entities;

import app.valuationcontrol.multimodule.library.entities.Model;
import app.valuationcontrol.multimodule.library.helpers.DataTransformer;
import app.valuationcontrol.multimodule.library.records.ModelData;
import app.valuationcontrol.multimodule.library.records.SingleModelAccessData;
import app.valuationcontrol.multimodule.library.records.UserData;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.springframework.security.access.AccessDeniedException;

@Entity
@Table(name="\"User\"", uniqueConstraints={@UniqueConstraint(columnNames={"user_email"})})
public class User
implements DataTransformer<UserData> {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    @Column(name="user_email")
    private String email;
    @Column(name="user_sub")
    private String sub;
    @ElementCollection
    private final Map<Model, String> modelRoles = new HashMap<Model, String>();

    public String getModelRoleWithModelId(long modelId) {
        return this.modelRoles.entrySet().stream().filter(entry -> ((Model)entry.getKey()).getId() == modelId).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    public boolean getModelIsLocked(long modelId) {
        return this.modelRoles.entrySet().stream().anyMatch(entry -> ((Model)entry.getKey()).getId() == modelId && ((Model)entry.getKey()).isLocked());
    }

    public boolean validateRole(String requiredRole, Long modelId, boolean isAnUnlockRequest) throws AccessDeniedException {
        String userRole = this.getModelRoleWithModelId(modelId);
        boolean isLocked = this.getModelIsLocked(modelId);
        if (userRole == null) {
            throw new AccessDeniedException("User does not have access to this model");
        }
        MODEL_ROLE userModelRole = MODEL_ROLE.valueOf(userRole);
        MODEL_ROLE requiredModelRole = MODEL_ROLE.valueOf(requiredRole);
        if (isAnUnlockRequest && userModelRole.equals((Object)requiredModelRole)) {
            return true;
        }
        if (isLocked && MODEL_ROLE.READER.equals((Object)requiredModelRole)) {
            return true;
        }
        if (isLocked && (MODEL_ROLE.EDITOR.equals((Object)requiredModelRole) || MODEL_ROLE.ADMIN.equals((Object)requiredModelRole))) {
            throw new AccessDeniedException("Model is locked for changes. Ask an administrator to unlock the model.");
        }
        if (userModelRole.equals((Object)MODEL_ROLE.ADMIN)) {
            return true;
        }
        if (MODEL_ROLE.EDITOR.equals((Object)userModelRole) && (MODEL_ROLE.EDITOR.equals((Object)requiredModelRole) || MODEL_ROLE.READER.equals((Object)requiredModelRole))) {
            return true;
        }
        return MODEL_ROLE.READER.equals((Object)userModelRole) && MODEL_ROLE.READER.equals((Object)requiredModelRole);
    }

    public void addModel(Model model, MODEL_ROLE role) {
        this.getModelRoles().put(model, role.name());
    }

    @Override
    public UserData asData() {
        ArrayList<SingleModelAccessData> asData = new ArrayList<SingleModelAccessData>();
        this.modelRoles.forEach((model, access) -> {
            SingleModelAccessData accessData = new SingleModelAccessData(MODEL_ROLE.valueOf(access), model.asData());
            asData.add(accessData);
        });
        asData.sort(Comparator.comparing(SingleModelAccessData::modelData, Comparator.comparing(ModelData::name)));
        return new UserData(this.getId(), this.getEmail(), this.getSub(), asData);
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getSub() {
        return this.sub;
    }

    @Generated
    public Map<Model, String> getModelRoles() {
        return this.modelRoles;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    public static enum MODEL_ROLE {
        ADMIN,
        EDITOR,
        READER;

    }
}

