package app.valuationcontrol.webservice.enin.records;

import jakarta.validation.constraints.NotNull;

@SuppressWarnings("unused")
public record IncomeStatementRecord(
    String uuid,
    @NotNull String accounts_uuid,
    String currency_code,
    Float total_sales,
    Float other_operating_income,
    Float total_operating_income,
    Float cost_of_goods_sold,
    Float inventory_change,
    Float personnel_expenses,
    Float ordinary_depreciation,
    Float write_downs,
    Float other_operating_expenses,
    Float total_operating_expenses,
    Float operating_profit,
    Float share_of_profit_of_subsidiaries,
    Float share_of_profit_from_group_companies,
    Float other_interest_income,
    Float share_of_profit_from_associated_companies,
    Float interest_income_from_group_companies,
    Float total_other_fin_income,
    Float total_fin_income,
    Float total_other_interest_expenses,
    Float write_down_of_short_term_fin_assets,
    Float write_down_of_other_short_term_fin_assets,
    Float write_down_of_long_term_fin_assets,
    Float other_fin_expenses,
    Float total_other_fin_expenses,
    Float total_fin_expenses,
    Float total_fin_items,
    Float ordinary_result_before_taxes,
    Float taxes_on_ordinary_result,
    Float ordinary_result,
    Float extraordinary_income,
    Float extraordinary_expenses,
    Float total_extraordinary_items,
    Float taxes_on_extraordinary_result,
    Float total_taxes,
    Float minority_interest,
    Float net_income,
    Float dividend,
    Float intra_group_contribution,
    Float transferred_equity,
    Float manager_remuneration,
    Float manager_remuneration_only_salary,
    Float manager_other_remuneration,
    Float auditor_remuneration,
    Float board_remuneration,
    Float consultant_remuneration,
    Integer accounting_year,
    Float total_unaccounted_for_fin_income,
    Float total_unaccounted_for_operating_expenses,
    Float total_unaccounted_for_fin_expenses,
    @NotNull String company_uuid,
    @NotNull String accounts_type_uuid,
    Float gross_profit,
    String app_url) {}
