package app.valuationcontrol.webservice.helpers;

import static app.valuationcontrol.webservice.helpers.EntityDTOConverter.asData;

import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.model.ModelData;
import app.valuationcontrol.webservice.model.area.AreaData;
import app.valuationcontrol.webservice.model.graph.ModelGraphData;
import app.valuationcontrol.webservice.model.segment.SegmentData;
import app.valuationcontrol.webservice.model.sensitivity.SensitivityData;
import app.valuationcontrol.webservice.model.sensitivity.SensitivityResult;
import app.valuationcontrol.webservice.model.variable.VariableData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Data;

@Data
public class CalculationData {

  private ModelData model;
  private List<SegmentData> segments = new ArrayList<>();
  private List<AreaData> areas = new ArrayList<>();
  private List<ModelGraphData> graphs = new ArrayList<>();
  private List<VariableData> variables = new ArrayList<>();
  private List<SensitivityData> sensitivities = new ArrayList<>();
  private Map<Long, List<CellError>> formulaErrors;
  private Map<Long, List<CellError>> variableCellErrors;
  private List<SensitivityResult> sensitivityResults = new ArrayList<>();
  private int scenarioNumber = 0;

  // For deserialization
  public CalculationData() {}

  /**
   * @param model the model
   * @param sensitivityResults sensitivityResults
   * @param formulaErrors formula errors
   * @param variableCellErrors cell errors
   */
  public CalculationData(
      Model model,
      List<SensitivityResult> sensitivityResults,
      Map<Long, List<CellError>> formulaErrors,
      Map<Long, List<CellError>> variableCellErrors,
      int scenarioNumber) {
    this.model = asData(model);
    this.segments = asData(model.getSegments());
    this.areas = asData(model.getAreas());
    this.graphs = asData(model.getGraphs());
    this.sensitivities = asData(model.getSensitivities());
    this.variables =
        asData(
            model.getVariables().stream()
                .sorted(
                    (o1, o2) -> {
                      if (Objects.equals(o1.getVariableAreaId(), o2.getVariableAreaId())) {
                        if (Objects.equals(o1.getVariableSubAreaId(), o2.getVariableSubAreaId())) {
                          return o1.getVariableOrder().compareTo(o2.getVariableOrder());
                        } else {
                          return o1.getVariableSubArea()
                              .getSubAreaOrder()
                              .compareTo(o2.getVariableSubArea().getSubAreaOrder());
                        }
                      } else {
                        return o1.getVariableArea()
                            .getAreaOrder()
                            .compareTo(o2.getVariableArea().getAreaOrder());
                      }
                    })
                .toList());
    this.variableCellErrors = variableCellErrors;
    this.sensitivityResults = sensitivityResults;
    this.formulaErrors = formulaErrors;
    this.scenarioNumber = scenarioNumber;
  }
}
