package app.valuationcontrol.webservice.helpers;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.regex.Pattern;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.lang.NonNull;

/**
 * Helper class to manage % inputs to Float
 *
 * @author thomas
 */
@Log4j2
public class MyCustomFloatEditor extends CustomNumberEditor {

  public static final NumberFormat PERCENT_INSTANCE = NumberFormat.getPercentInstance(Locale.US);
  private static final String CHARACTERS = ".*[a-zA-Z].*";
  private static final Pattern PATTERN = Pattern.compile(CHARACTERS);

  public MyCustomFloatEditor(Class<? extends Number> numberClass, boolean allowEmpty)
      throws IllegalArgumentException {
    super(numberClass, allowEmpty);
  }

  /** Converts string to Float and manage % and , */
  @Override
  public void setAsText(@NonNull String text) throws IllegalArgumentException {

    text = text.replace(",", ".");

    // Check if the text contains a percentage but no character A-Z
    if (text.contains("%") && textHasNoCharacters(text)) {
      try {
        super.setAsText(String.valueOf(PERCENT_INSTANCE.parse(text)));
      } catch (ParseException e) {
        log.debug(e);
        throw new IllegalArgumentException();
      }
    } else {
      super.setAsText(text);
    }
  }

  private boolean textHasNoCharacters(String text) {
    return !PATTERN.matcher(text).matches();
  }
}
