package app.valuationcontrol.webservice.helpers;

import java.util.function.Supplier;
import lombok.extern.log4j.Log4j2;

@Log4j2
public abstract class Timer {
  private Timer() {}

  public static <T> T measure(Supplier<T> supplier, String title) {
    long now = System.currentTimeMillis();

    T t = supplier.get();

    log.info("{} took: {} milliseconds", title, (System.currentTimeMillis() - now));

    return t;
  }
}
