package app.valuationcontrol.webservice.helpers.poiudf;

import java.time.Instant;
import java.time.Period;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import lombok.extern.log4j.Log4j2;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.formula.eval.*;
import org.apache.poi.ss.formula.functions.Function;
import org.apache.poi.ss.usermodel.DateUtil;

@Log4j2
public final class DateDif implements Function {
  // Registered in XLHandleManager
  @Override
  public ValueEval evaluate(ValueEval[] valueEvals, int srcCellRow, int srcCellCol) {
    if (valueEvals.length != 3) {
      return ErrorEval.VALUE_INVALID;
    }

    try {

      ValueEval v1 = OperandResolver.getSingleValue(valueEvals[0], srcCellRow, srcCellCol);
      ValueEval v2 = OperandResolver.getSingleValue(valueEvals[1], srcCellRow, srcCellCol);

      double startDate = OperandResolver.coerceValueToDouble(v1);
      double endDate = OperandResolver.coerceValueToDouble(v2);
      String unit = OperandResolver.coerceValueToString(valueEvals[2]);

      //      log.debug(
      //          "Resolving datedif for {},{},{}",
      //          OperandResolver.coerceValueToInt(v1),
      //          OperandResolver.coerceValueToInt(v2),
      //          unit);

      Instant javaStartDate = DateUtil.getJavaDate(startDate).toInstant();
      Instant javaEndDate = DateUtil.getJavaDate(endDate).toInstant();
      Period period =
          Period.between(
              javaStartDate.atZone(ZoneId.systemDefault()).toLocalDate(),
              javaEndDate.atZone(ZoneId.systemDefault()).toLocalDate());

      return switch (unit) {
        case "y" -> new NumberEval(period.getYears());
        case "m" -> new NumberEval(period.getYears() * 12 + period.getMonths());
        case "d" -> new NumberEval(ChronoUnit.DAYS.between(javaStartDate, javaEndDate));
        default -> new NumberEval(ChronoUnit.YEARS.between(javaStartDate, javaEndDate));
      };

    } catch (EvaluationException | FormulaParseException e) {
      return ErrorEval.REF_INVALID;
    }
  }
}
