package app.valuationcontrol.webservice.model;

import jakarta.validation.constraints.*;

public record ModelData(
    Long id,
    @NotEmpty @NotNull String name,
    @NotNull @Min(value = 0, message = "Start year must be greater than 0") Integer startYear,
    @NotNull
        @Min(value = 0, message = "Number of historical periods can't be less than 0")
        @Max(value = 5, message = "You can only have 5 years of historical periods")
        Integer nbHistoricalPeriod,
    @NotNull
        @Min(value = 1, message = "You need at least one projection period")
        @Max(value = 21, message = "You can only have 20 years of projection periods")
        Integer nbProjectionPeriod,
    @NotNull String company,
    String companyNumber,
    @NotNull
        @Size(min = 1, max = 5, message = "Currency must be a string between 1 to 5 characters")
        String currency,
    @Pattern(regexp = "property|template|") String simpleModel,
    boolean locked,
    boolean includeYTD,
    KeyParam keyParam) {}
