package app.valuationcontrol.webservice.model.events.listeners;

import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.model.logentry.LogEntry;
import app.valuationcontrol.webservice.model.logentry.LogEntryRepository;
import java.security.Principal;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditLog {

  private final LogEntryRepository logEntryRepository;

  @Autowired
  public AuditLog(LogEntryRepository logEntryRepository) {
    this.logEntryRepository = logEntryRepository;
  }

  public void log(Model model, String action, Principal user) {
    log(this.logEntryRepository, model, action, user);
  }

  public static void log(
      LogEntryRepository logEntryRepository, Model model, String action, Principal user) {
    LogEntry logEntry = new LogEntry();

    logEntry.setAction(action);
    logEntry.setAttachedModel(model);
    logEntry.setUsername(user.getName());
    logEntry.setChangeDate(LocalDateTime.now());
    logEntry.setIsModelChange(false);
    logEntry.setFromFormula("");
    logEntry.setToFormula("");

    logEntryRepository.save(logEntry);
  }

  public static void log(
      LogEntryRepository logEntryRepository,
      Model model,
      String action,
      Principal user,
      String formulaBefore,
      String formulaAfter,
      Long variableId) {
    LogEntry logEntry = new LogEntry();

    logEntry.setAction(action);
    logEntry.setAttachedModel(model);
    logEntry.setUsername(user.getName());
    logEntry.setChangeDate(LocalDateTime.now());
    logEntry.setIsModelChange(false);
    logEntry.setFromFormula(formulaBefore);
    logEntry.setToFormula(formulaAfter);
    logEntry.setVariableId(variableId);
    logEntryRepository.save(logEntry);
  }
}
