package app.valuationcontrol.webservice.model.events.listeners;

import app.valuationcontrol.webservice.EntityService;
import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.model.events.Event;
import app.valuationcontrol.webservice.user.User;
import app.valuationcontrol.webservice.user.UserRepository;
import java.security.Principal;
import lombok.extern.log4j.Log4j2;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Log4j2
@Component
public class ConnectUserToModelWhenCreated {

  private final EntityService entityService;
  private final UserRepository userRepository;

  public ConnectUserToModelWhenCreated(EntityService entityService, UserRepository userRepository) {
    this.entityService = entityService;
    this.userRepository = userRepository;
  }

  @SuppressWarnings("unused")
  @EventListener
  public void onEvent(Event<Model> event) {
    // Event<Model> event = (Event<Model>) genericEvent;
    if (event.isCreate()) {
      connectToUser(event.getNewVersion(), event.getPrincipal());
    }
  }

  private void connectToUser(Model newModel, Principal principal) {

    User byEmail = userRepository.findByEmail(principal.getName());

    if (byEmail == null) {
      log.warn("User {} could not be found", principal.getName());
      byEmail = new User();
      byEmail.setEmail(principal.getName());
    }

    byEmail.addModel(newModel, User.MODEL_ROLE.ADMIN);

    entityService.safeUpdate(User.class, byEmail, byEmail);
  }
}
