package app.valuationcontrol.webservice.model.events.listeners.logger;

import static app.valuationcontrol.webservice.model.events.listeners.AuditLog.log;

import app.valuationcontrol.webservice.model.events.Event;
import app.valuationcontrol.webservice.model.logentry.LogEntryRepository;
import app.valuationcontrol.webservice.model.variable.Variable;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class VariableLogger {

  private final LogEntryRepository logEntryRepository;

  public VariableLogger(LogEntryRepository logEntryRepository) {
    this.logEntryRepository = logEntryRepository;
  }

  @EventListener
  public void onEvent(Event<Variable> event) {
    /// Event<Variable> event = (Event<Variable>) genericEvent;
    switch (event.getType()) {
      case CREATED -> {
        final Variable entity = event.getNewVersion();
        log(
            logEntryRepository,
            entity.getAttachedModel(),
            "Create variable " + entity.getVariableType(),
            event.getPrincipal(),
            null,
            entity.getVariableFormula(),
            entity.getId());
      }
      case DELETED -> {
        final Variable entity = event.getOldVersion();
        log(
            logEntryRepository,
            entity.getAttachedModel(),
            "Deleted variable " + entity.getVariableName(),
            event.getPrincipal(),
            entity.getVariableFormula(),
            "",
            entity.getId());
      }
      case UPDATED, METADATA_UPDATE -> {
        final Variable oldVersion = event.getOldVersion();
        final Variable newVersion = event.getNewVersion();

        log(
            logEntryRepository,
            oldVersion.getAttachedModel(),
            "Update variable "
                + oldVersion.getVariableName()
                + " ( "
                + newVersion.getVariableName()
                + ")",
            event.getPrincipal(),
            oldVersion.getVariableFormula(),
            newVersion.getVariableFormula(),
            newVersion.getId());
      }
    }
  }
}
