package app.valuationcontrol.webservice.model.sensitivity;

import java.math.BigDecimal;
import java.math.RoundingMode;
import lombok.Getter;

/**
 * Stores the results of a sensitivity run
 *
 * @author thoma
 */
@Getter
public class SensitivityResult {
  private Long id = null;
  boolean isValid = false;

  @SuppressWarnings("MismatchedReadAndWriteOfArray")
  private BigDecimal[] variable1Values;

  @SuppressWarnings("MismatchedReadAndWriteOfArray")
  private BigDecimal[] variable2Values;

  @SuppressWarnings("MismatchedReadAndWriteOfArray")
  private BigDecimal[][][] myResultArray;

  private Integer scenarioNumber;

  @SuppressWarnings("unused") // For deserialization
  public SensitivityResult() {}

  public SensitivityResult(
      Long id,
      Integer scenarioNumber,
      Integer variable1Steps,
      Integer variable2Steps,
      Integer numberOfSegments) {
    this.id = id;
    this.scenarioNumber = scenarioNumber;
    variable1Values = new BigDecimal[variable1Steps];
    variable2Values = new BigDecimal[variable2Steps];
    myResultArray = new BigDecimal[numberOfSegments][variable1Steps][variable2Steps];
    this.isValid = true;
  }

  public void setValid(boolean isValid) {
    this.isValid = isValid;
  }

  /*converts to big decimal to ensure correct format*/
  public BigDecimal convertToBigDecimal(Double value) {
    BigDecimal temp = new BigDecimal(value);
    temp = temp.setScale(3, RoundingMode.HALF_UP);
    return temp;
  }

  public void setVariable1Values(int i, Double insertValue) {
    this.variable1Values[i] = convertToBigDecimal(insertValue);
  }

  public void setVariable2Values(int i, Double insertValue) {
    this.variable2Values[i] = convertToBigDecimal(insertValue);
  }

  public void setMyResultArray(int segmentIndex, int i, int j, double value) {
    this.myResultArray[segmentIndex][i][j] = convertToBigDecimal(value);
  }
}
