package app.valuationcontrol.webservice.model.variable;

import static app.valuationcontrol.webservice.openai.OpenAIHelperFunctions.getDoubleFromObject;

import app.valuationcontrol.webservice.model.EvenBrackets;
import app.valuationcontrol.webservice.model.EvenParenthesis;
import app.valuationcontrol.webservice.model.variablevalue.VariableValueData;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Pattern;
import java.util.List;

public record VariableData(
    Long id,
    @NotEmpty @Pattern(regexp = "^(?:[A-z]|[0-9]|[ ]|[%])*") String variableName,
    String variableDescription,
    Long variableAreaId,
    Long variableSubAreaId,
    @EvenParenthesis @EvenBrackets String variableFormula,
    @NotEmpty
        @Pattern(
            regexp = "input|calc|constant|check|single_result|kpi|sub_total_row|total_row",
            flags = Pattern.Flag.CASE_INSENSITIVE)
        String variableType,
    Integer row,
    Integer variableOrder,
    Integer variableDepth,
    boolean variableApplyToHistoricals,
    @NotEmpty
        @Pattern(regexp = "decimal|integer|percent|date", flags = Pattern.Flag.CASE_INSENSITIVE)
        String variableFormat,
    List<VariableValueData> variableValues,
    List<Long> variableDependencies,
    String evaluatedVariableFormula,
    Long originalId,
    String evaluatedXLformula,
    List<Object[]> historicalValues,
    List<Object[]> projectionValues,
    boolean modelledAtSegment,
    List<Object> singleOrConstantValue,
    List<Object> yearToDateValue,
    List<Object> yearToGoValue) {

  public boolean isSingleEntry() {
    if (Variable.CONSTANT_OR_SINGLE.contains(this.variableType)) {
      return true;
    } else {
      return false;
    }
  }

  public Double getValueInPeriod(Integer period, Integer segmentIndex) {
    if (isSingleEntry() && singleOrConstantValue.size() > 0) {
      return getDoubleFromObject(singleOrConstantValue.get(segmentIndex), this);
    } else {
      if (period > 0
          && !projectionValues().isEmpty()
          && !(projectionValues().get(segmentIndex) == null))
        return getDoubleFromObject(projectionValues.get(segmentIndex)[period], this);

      if (period < 0
          && !historicalValues().isEmpty()
          && !(historicalValues().get(segmentIndex) == null))
        return getDoubleFromObject(historicalValues.get(segmentIndex)[period], this);
    }
    return null;
  }
}
