package app.valuationcontrol.webservice.model.variablevalue;

import app.valuationcontrol.webservice.PercentageFloatDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;

public record VariableValueData(
    long id,
    Integer period,
    @NotNull @JsonDeserialize(using = PercentageFloatDeserializer.class) Float value,
    LocalDateTime lastChanged,
    Integer scenarioNumber,
    Long attachedSegmentId,
    @NotNull Long attachedVariableId,
    String user,
    String sourceFile) {}
