package app.valuationcontrol.webservice.securityhelpers;

import java.util.Arrays;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author thoma Enable Method security
 */
@Configuration
public class AllowedOriginsConfiguration {

  @Bean
  @ConditionalOnProperty(name = "running.env", havingValue = Environments.DEV)
  public AllowedOrigins devAllowedOrigins() {
    return () ->
        Arrays.asList(
            "http://localhost",
            "http://localhost:3000",
            "https://localhost:3000",
            "http://developmentserver:3000");
  }

  @Bean
  @ConditionalOnProperty(name = "running.env", havingValue = Environments.PROD)
  public AllowedOrigins prodAllowedOrigins() {
    return () ->
        Arrays.asList("https://azure.valuationcontrol.app", "https://demo.valuationcontrol.app");
  }
}
