package app.valuationcontrol.webservice.securityhelpers;

import java.util.ArrayList;
import java.util.Collection;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.stereotype.Component;

@Component
@Log4j2
public class CustomAuthenticationProvider implements AuthenticationProvider {

  @Autowired UserDetailsService myUserDetailsService;

  @Override
  public Authentication authenticate(Authentication authentication) throws AuthenticationException {
    log.debug(
        "Authenticate: Checking user {}, is authenticated: {}",
        authentication.getName(),
        authentication.isAuthenticated());

    final String customToken = (String) authentication.getPrincipal();
    final String modelId = (String) authentication.getCredentials();
    // Custom logic to validate the token
    return getValidationToken(customToken, modelId);
  }

  // This code does not run if the user is already authenticated (Authentication fetched from
  // existing Session)
  private Authentication getValidationToken(String username, String modelId) {
    // call auth service to check validity of token
    Authentication returnAuth;
    UserDetails currentUser;
    Collection<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<>();

    // Checking that a modelid is specified
    if (username != null) {
      currentUser = myUserDetailsService.loadUserByUsername(username);
      if (currentUser != null) {
        grantedAuthorities.add(new SimpleGrantedAuthority("ROLE_User"));
        returnAuth =
            new UsernamePasswordAuthenticationToken(
                currentUser, modelId, grantedAuthorities); // Returns an authenticated user
        return returnAuth;
      }
    }
    throw new AuthenticationCredentialsNotFoundException("Couldn't find a user");
  }

  @Override
  public boolean supports(Class<?> authentication) {
    // Let's use inbuilt token class for simplicity
    return PreAuthenticatedAuthenticationToken.class.equals(authentication);
  }
}
