package app.valuationcontrol.webservice.xlhandler;

import app.valuationcontrol.webservice.helpers.DataPeriod;
import app.valuationcontrol.webservice.model.variable.Variable;
import app.valuationcontrol.webservice.model.variablevalue.VariableValue;

public class CellValueHelper {
  public static final int AZ_COUNTER = 26;

  public static GenericSheet.CellValue cellValueOf(VariableValue variableValue) {

    Variable variable = variableValue.getAttachedVariable();

    var columnIndex =
        variable.columnOfSegmentAndPeriod(
            variableValue.getAttachedSegment(), variableValue.getPeriod());

    return new GenericSheet.CellValue(variableValue.getValue(), columnIndex, variable.getRow());
  }

  /**
   * Returns the A1 address of the formula
   *
   * @param dataPeriod indicates which dataperiod we should generate address for
   * @return the generated address as a String
   */
  public static String generateAddress(Variable variable, DataPeriod dataPeriod) {
    int columnToAssess;
    if (variable.isSingleOrConstantValue()) {
      columnToAssess =
          (variable.getAttachedModel().getConstantColumn())
              + dataPeriod.getSegmentOffsetAsInteger();
    } else {
      columnToAssess = variable.getPrimaryColumn() + dataPeriod.getTotalOffsetAsInteger();
    }
    return generateAddress(variable, columnToAssess);
  }

  /**
   * Returns the A1 address of the formula
   *
   * @param columnToAssess indicates which column we should generate address for
   * @return the A1 address of the formula
   */
  public static String generateAddress(Variable variable, int columnToAssess) {
    String returnString;
    String prefix = "";
    String column;

    int rowToAssess = variable.getRow() + 1;
    int multiplier = columnToAssess / AZ_COUNTER;
    int rest = columnToAssess % AZ_COUNTER;

    // Defining column prefix AA
    if (multiplier >= 1) {
      prefix = Character.toString((char) (65 + multiplier - 1));
    }

    column = prefix + (char) (65 + rest);

    if (variable.isSingleOrConstantValue()) {
      returnString = "$" + column + "$" + rowToAssess;
    } else {
      returnString = column + rowToAssess;
    }

    return returnString;
  }
}
