package app.valuationcontrol.webservice.xlhandler;

import app.valuationcontrol.webservice.helpers.CalculationData;
import app.valuationcontrol.webservice.model.sensitivity.Sensitivity;
import app.valuationcontrol.webservice.model.sensitivity.SensitivityResult;
import app.valuationcontrol.webservice.model.variable.Variable;
import app.valuationcontrol.webservice.model.variablevalue.VariableValue;
import java.io.InputStream;
import java.time.Duration;
import java.util.List;

public interface ScenarioDataProvider {
  void runSensitivities(List<Sensitivity> sensitivity, SCENARIO scenario);

  CalculationData getContent(SCENARIO scenario);

  boolean isUnusedFor(Duration maxInactivity);

  void sleep();

  InputStream saveAs();

  void clearCacheAndReloadAndUpdateClients();

  void reloadAndUpdateClients();

  void refreshValue(Variable attachedVariable, VariableValue newVersion);

  void reloadVariableAndUpdateCache(Variable attachedVariable);

  List<SensitivityResult> getSensitivityResults();
}
