/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi.exceptions;

import com.fasterxml.jackson.databind.JsonNode;
import gg.xp.xivapi.exceptions.XivApiDeserializationException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jetbrains.annotations.Nullable;

public class XivApiMissingNodeException
extends XivApiDeserializationException {
    private final String messageBase;
    private final JsonNode node;
    private final Type fieldType;
    private final Method method;

    private static String formatMethodNullable(@Nullable Method method) {
        if (method == null) {
            return "not specified";
        }
        return method.getDeclaringClass().getSimpleName() + "." + method.getName();
    }

    public XivApiMissingNodeException(String messageBase, @Nullable JsonNode node, Type fieldType, @Nullable Method method) {
        super("Error deserializing node into %s (method %s): %s%nNode: %s".formatted(fieldType, XivApiMissingNodeException.formatMethodNullable(method), messageBase, node));
        this.messageBase = messageBase;
        this.node = node;
        this.fieldType = fieldType;
        this.method = method;
    }

    public String getMessageBase() {
        return this.messageBase;
    }

    public JsonNode getNode() {
        return this.node;
    }

    public Type getFieldType() {
        return this.fieldType;
    }

    public Method getMethod() {
        return this.method;
    }
}

