/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi.mappers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import gg.xp.xivapi.annotations.EmptyStringNull;
import gg.xp.xivapi.exceptions.XivApiException;
import gg.xp.xivapi.impl.XivApiContext;
import gg.xp.xivapi.mappers.FieldMapper;
import gg.xp.xivapi.mappers.QueryFieldsBuilder;
import java.lang.reflect.Method;

public class BasicValueMapper<X>
implements FieldMapper<X> {
    private final Class<X> fieldType;
    private final ObjectMapper mapper;
    private final boolean blankNull;

    public BasicValueMapper(Class<X> fieldType, Method method, ObjectMapper mapper) {
        this.fieldType = fieldType;
        this.mapper = mapper;
        boolean bl = this.blankNull = method.isAnnotationPresent(EmptyStringNull.class) || method.getAnnotatedReturnType().isAnnotationPresent(EmptyStringNull.class);
        if (this.blankNull && !fieldType.equals(String.class)) {
            throw new IllegalArgumentException("Method '" + String.valueOf(method) + "' must have a non-empty String");
        }
    }

    @Override
    public X getValue(JsonNode current, XivApiContext context) {
        try {
            Object out = this.mapper.convertValue((Object)current, this.fieldType);
            if (this.blankNull && "".equals(out)) {
                return null;
            }
            return (X)out;
        }
        catch (Throwable t) {
            throw new XivApiException("Error deserializing value %s into %s".formatted(current, this.fieldType), t);
        }
    }

    @Override
    public void buildQueryFields(QueryFieldsBuilder parent) {
    }
}

