/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi.mappers;

import gg.xp.xivapi.exceptions.XivApiException;
import gg.xp.xivapi.mappers.QueryFieldsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;

public final class RootQueryFieldsBuilder
extends QueryFieldsBuilder {
    public RootQueryFieldsBuilder() {
        super("$ROOT$", false, false, List.of(), List.of());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RootQueryFieldsBuilder{");
        sb.append("fields=");
        sb.append(this.children.stream().filter(qf -> !qf.isTransient).flatMap(qf -> {
            try {
                return qf.toQueryStrings(true).stream();
            }
            catch (Throwable t) {
                return Stream.of("%s(ERROR)".formatted(qf.name));
            }
        }).collect(Collectors.joining(", ")));
        sb.append("; transients=");
        sb.append(this.children.stream().filter(qf -> qf.isTransient).flatMap(qf -> {
            try {
                return qf.toQueryStrings(true).stream();
            }
            catch (Throwable t) {
                return Stream.of("%s(ERROR)".formatted(qf.name));
            }
        }).collect(Collectors.joining(", ")));
        sb.append("}");
        return sb.toString();
    }

    public List<NameValuePair> formatQueryFields() {
        ArrayList<String> normalFields = new ArrayList<String>();
        boolean normalAll = this.children.stream().anyMatch(child -> !child.isTransient && child.isAll());
        ArrayList<String> transientFields = new ArrayList<String>();
        boolean transientAll = this.children.stream().anyMatch(child -> child.isTransient && child.isAll());
        for (QueryFieldsBuilder child2 : this.children) {
            List<String> queryStrings = child2.toQueryStrings(true);
            if (child2.isTransient) {
                if (transientAll) {
                    for (String queryString : queryStrings) {
                        if (!queryString.contains("@")) continue;
                        throw new XivApiException("Impossible combination of fields: cannot combine @XivApiThis with [%s]".formatted(queryString));
                    }
                }
                transientFields.addAll(queryStrings);
                continue;
            }
            if (normalAll) {
                for (String queryString : queryStrings) {
                    if (!queryString.contains("@")) continue;
                    throw new XivApiException("Impossible combination of fields: cannot combine @XivApiThis with [%s]".formatted(queryString));
                }
            }
            normalFields.addAll(queryStrings);
        }
        ArrayList<NameValuePair> out = new ArrayList<NameValuePair>();
        if (normalAll) {
            out.add((NameValuePair)new BasicNameValuePair("fields", "*"));
        } else if (!normalFields.isEmpty()) {
            out.add((NameValuePair)new BasicNameValuePair("fields", String.join((CharSequence)",", normalFields)));
        }
        if (transientAll) {
            out.add((NameValuePair)new BasicNameValuePair("transient", "*"));
        } else if (!transientFields.isEmpty()) {
            out.add((NameValuePair)new BasicNameValuePair("transient", String.join((CharSequence)",", transientFields)));
        }
        return out;
    }
}

