/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi.pagination;

import gg.xp.xivapi.mappers.util.ThreadingUtils;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedIterator<X>
implements Iterator<X> {
    private static final Logger log = LoggerFactory.getLogger(BufferedIterator.class);
    private final int bufferSize;
    private final Queue<X> buffer = new ArrayDeque<X>();
    private final Object lock = new Object();
    private volatile boolean done;

    public BufferedIterator(Iterator<X> iter, int bufferSize) {
        this.bufferSize = bufferSize;
        ThreadingUtils.tryStartVirtualThread(() -> {
            try {
                iter.forEachRemaining(this::add);
            }
            catch (Throwable t) {
                log.error("BufferedIterator failed to read from {}", (Object)iter, (Object)t);
            }
            finally {
                this.done();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(X item) {
        Object object = this.lock;
        synchronized (object) {
            while (this.buffer.size() >= this.bufferSize) {
                try {
                    this.lock.wait(10000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.buffer.add(item);
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void done() {
        Object object = this.lock;
        synchronized (object) {
            this.done = true;
            this.lock.notifyAll();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasNext() {
        Object object = this.lock;
        synchronized (object) {
            X next;
            while ((next = this.buffer.peek()) == null) {
                if (this.done) {
                    return false;
                }
                try {
                    this.lock.wait(10000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public X next() {
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                X next;
                if ((next = this.buffer.poll()) != null) {
                    this.lock.notifyAll();
                    return next;
                }
                if (this.done) {
                    throw new NoSuchElementException("Iteration done");
                }
                try {
                    this.lock.wait(10000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

