/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core.layout;

import ar.com.fdvs.dj.core.DJDefaultScriptlet;
import ar.com.fdvs.dj.core.layout.AbstractLayoutManager;
import ar.com.fdvs.dj.core.layout.CrossTabColorShema;
import ar.com.fdvs.dj.core.layout.CrossTabColorShemaGenerator;
import ar.com.fdvs.dj.core.registration.EntitiesRegistrationException;
import ar.com.fdvs.dj.domain.DJCRosstabMeasurePrecalculatedTotalProvider;
import ar.com.fdvs.dj.domain.DJCrosstab;
import ar.com.fdvs.dj.domain.DJCrosstabColumn;
import ar.com.fdvs.dj.domain.DJCrosstabMeasure;
import ar.com.fdvs.dj.domain.DJCrosstabRow;
import ar.com.fdvs.dj.domain.DJValueFormatter;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.entities.conditionalStyle.ConditionStyleExpression;
import ar.com.fdvs.dj.domain.entities.conditionalStyle.ConditionalStyle;
import ar.com.fdvs.dj.util.ExpressionUtils;
import ar.com.fdvs.dj.util.HyperLinkUtil;
import ar.com.fdvs.dj.util.Utils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabBucket;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabCell;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabDataset;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabMeasure;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabParameter;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseBox;
import net.sf.jasperreports.engine.design.JRDesignConditionalStyle;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Dj2JrCrosstabBuilder {
    private static final Log log = LogFactory.getLog((Class)Dj2JrCrosstabBuilder.class);
    private static final Random random = new Random();
    private JasperDesign design;
    private JRDesignCrosstab jrcross;
    private DJCrosstab djcross;
    private DJCrosstabColumn[] cols;
    private DJCrosstabRow[] rows;
    private Color[][] colors;
    private AbstractLayoutManager layoutManager;

    public JRDesignCrosstab createCrosstab(DJCrosstab djcrosstab, AbstractLayoutManager layoutManager) {
        this.djcross = djcrosstab;
        this.layoutManager = layoutManager;
        this.design = layoutManager.getDesign();
        this.jrcross = new JRDesignCrosstab();
        this.jrcross.setPositionType((byte)2);
        this.cols = djcrosstab.getColumns().toArray(new DJCrosstabColumn[0]);
        this.rows = djcrosstab.getRows().toArray(new DJCrosstabRow[0]);
        JRDesignExpression mapExp = new JRDesignExpression();
        mapExp.setText("$P{REPORT_PARAMETERS_MAP}");
        mapExp.setValueClass(Map.class);
        this.jrcross.setParametersMapExpression((JRExpression)mapExp);
        JRDesignCrosstabParameter crossParameter = new JRDesignCrosstabParameter();
        crossParameter.setName("REPORT_SCRIPTLET");
        crossParameter.setValueClassName(DJDefaultScriptlet.class.getName());
        JRDesignExpression expression = new JRDesignExpression();
        expression.setText("$P{REPORT_PARAMETERS_MAP}.get(\"REPORT_SCRIPTLET\")");
        expression.setValueClassName(DJDefaultScriptlet.class.getName());
        crossParameter.setExpression((JRExpression)expression);
        try {
            this.jrcross.addParameter((JRCrosstabParameter)crossParameter);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        this.initColors();
        this.setCrosstabOptions();
        this.registerColumns();
        this.registerRows();
        this.registerMeasures();
        this.createCells();
        this.createMainHeaderCell();
        this.registerDataSet(djcrosstab);
        return this.jrcross;
    }

    private void setCrosstabOptions() {
        if (this.djcross.isUseFullWidth()) {
            this.jrcross.setWidth(this.layoutManager.getReport().getOptions().getPrintableWidth());
        } else {
            this.jrcross.setWidth(this.djcross.getWidth());
        }
        this.jrcross.setHeight(this.djcross.getHeight());
        this.jrcross.setColumnBreakOffset(this.djcross.getColumnBreakOffset());
    }

    private void createMainHeaderCell() {
        JRDesignCellContents contents = new JRDesignCellContents();
        contents.setBackcolor(this.colors[this.colors.length - 1][this.colors[0].length - 1]);
        contents.setMode(new Byte(Transparency.OPAQUE.getValue()));
        this.jrcross.setHeaderCell(contents);
        JRDesignTextField element = new JRDesignTextField();
        String text = "";
        int auxHeight = 0;
        int auxWidth = 0;
        if (this.djcross.isAutomaticTitle()) {
            text = this.createAutomaticMainHeaderTitle();
        } else if (this.djcross.getMainHeaderTitle() != null) {
            text = "\"" + this.djcross.getMainHeaderTitle() + "\"";
        }
        Iterator iterator = this.djcross.getColumns().iterator();
        while (iterator.hasNext()) {
            DJCrosstabColumn col = (DJCrosstabColumn)iterator.next();
            auxHeight += col.getHeaderHeight();
        }
        iterator = this.djcross.getRows().iterator();
        while (iterator.hasNext()) {
            DJCrosstabRow row = (DJCrosstabRow)iterator.next();
            auxWidth += row.getHeaderWidth();
        }
        JRDesignExpression exp = ExpressionUtils.createStringExpression(text);
        element.setExpression((JRExpression)exp);
        element.setWidth(auxWidth);
        element.setHeight(auxHeight);
        element.setStretchWithOverflow(true);
        if (this.djcross.getHeaderStyle() != null) {
            this.layoutManager.applyStyleToElement(this.djcross.getHeaderStyle(), (JRDesignElement)element);
        }
        this.applyCellBorder(contents);
        contents.addElement((JRDesignElement)element);
    }

    private String createAutomaticMainHeaderTitle() {
        String text = "";
        Iterator iterator = this.djcross.getColumns().iterator();
        while (iterator.hasNext()) {
            DJCrosstabColumn col = (DJCrosstabColumn)iterator.next();
            text = text + col.getTitle();
            if (!iterator.hasNext()) continue;
            text = text + ", ";
        }
        text = text + "\\nvs.\\n";
        iterator = this.djcross.getRows().iterator();
        while (iterator.hasNext()) {
            DJCrosstabRow row = (DJCrosstabRow)iterator.next();
            text = text + row.getTitle();
            if (!iterator.hasNext()) continue;
            text = text + ", ";
        }
        text = "\"" + text + "\"";
        return text;
    }

    private void initColors() {
        CrossTabColorShema colorScheme = this.djcross.getCtColorScheme();
        if (colorScheme != null) {
            colorScheme.create(this.cols.length, this.rows.length);
            this.colors = colorScheme.getColors();
        } else {
            this.colors = CrossTabColorShemaGenerator.createSchema(this.djcross.getColorScheme(), this.cols.length, this.rows.length);
        }
    }

    private void registerDataSet(DJCrosstab djcrosstab) {
        JRDesignField field;
        int i;
        JRDesignCrosstabDataset dataset = new JRDesignCrosstabDataset();
        dataset.setDataPreSorted(djcrosstab.getDatasource().isPreSorted());
        JRDesignDatasetRun datasetRun = new JRDesignDatasetRun();
        JRDesignExpression exp = ExpressionUtils.getDataSourceExpression(djcrosstab.getDatasource());
        datasetRun.setDataSourceExpression((JRExpression)exp);
        dataset.setDatasetRun((JRDatasetRun)datasetRun);
        JRDesignDataset jrDataset = new JRDesignDataset(false);
        for (i = this.rows.length - 1; i >= 0; --i) {
            DJCrosstabRow crosstabRow = this.rows[i];
            field = new JRDesignField();
            field.setName(crosstabRow.getProperty().getProperty());
            field.setValueClassName(crosstabRow.getProperty().getValueClassName());
            try {
                jrDataset.addField((JRField)field);
                continue;
            }
            catch (JRException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        for (i = this.cols.length - 1; i >= 0; --i) {
            DJCrosstabColumn crosstabColumn = this.cols[i];
            field = new JRDesignField();
            field.setName(crosstabColumn.getProperty().getProperty());
            field.setValueClassName(crosstabColumn.getProperty().getValueClassName());
            try {
                jrDataset.addField((JRField)field);
                continue;
            }
            catch (JRException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        Iterator iterator = djcrosstab.getMeasures().iterator();
        while (iterator.hasNext()) {
            JRDesignField field2 = new JRDesignField();
            DJCrosstabMeasure djmeasure = (DJCrosstabMeasure)iterator.next();
            field2.setName(djmeasure.getProperty().getProperty());
            field2.setValueClassName(djmeasure.getProperty().getValueClassName());
            try {
                jrDataset.addField((JRField)field2);
            }
            catch (JRException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.jrcross.setDataset(dataset);
        String dsName = "crosstabDataSource_" + Math.abs(random.nextLong());
        while (this.design.getDatasetMap().containsKey(dsName)) {
            dsName = "crosstabDataSource_" + Math.abs(random.nextLong());
        }
        datasetRun.setDatasetName(dsName);
        jrDataset.setName(dsName);
        log.debug((Object)("Crosstab dataset name = " + dsName));
        try {
            if (!this.design.getDatasetMap().containsKey(jrDataset.getName())) {
                this.design.addDataset(jrDataset);
            }
        }
        catch (JRException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void createCells() {
        DJCrosstabColumn auxCol = new DJCrosstabColumn();
        DJCrosstabRow auxRow = new DJCrosstabRow();
        try {
            BeanUtils.copyProperties((Object)auxCol, this.djcross.getColumns().get(this.djcross.getColumns().size() - 1));
            BeanUtils.copyProperties((Object)auxRow, this.djcross.getRows().get(this.djcross.getRows().size() - 1));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        auxCol.setProperty(null);
        auxRow.setProperty(null);
        ArrayList<DJCrosstabColumn> auxColsList = new ArrayList<DJCrosstabColumn>(this.djcross.getColumns());
        auxColsList.add(auxCol);
        ArrayList<DJCrosstabRow> auxRowsList = new ArrayList<DJCrosstabRow>(this.djcross.getRows());
        auxRowsList.add(auxRow);
        DJCrosstabColumn[] auxCols = auxColsList.toArray(new DJCrosstabColumn[0]);
        DJCrosstabRow[] auxRows = auxRowsList.toArray(new DJCrosstabRow[0]);
        for (int i = auxCols.length - 1; i >= 0; --i) {
            for (int j = auxRows.length - 1; j >= 0; --j) {
                boolean isColumnTotal;
                DJCrosstabColumn crosstabColumn = auxCols[i];
                DJCrosstabRow crosstabRow = auxRows[j];
                JRDesignCrosstabCell cell = new JRDesignCrosstabCell();
                cell.setWidth(new Integer(crosstabColumn.getWidth()));
                cell.setHeight(new Integer(crosstabRow.getHeight()));
                boolean isRowTotal = crosstabRow.getProperty() != null;
                boolean bl = isColumnTotal = crosstabColumn.getProperty() != null;
                if (isColumnTotal) {
                    cell.setColumnTotalGroup(crosstabColumn.getProperty().getProperty());
                }
                if (isRowTotal) {
                    cell.setRowTotalGroup(crosstabRow.getProperty().getProperty());
                }
                JRDesignCellContents contents = new JRDesignCellContents();
                int counter = 0;
                int measureHeight = crosstabRow.getHeight() / this.djcross.getMeasures().size();
                Iterator iterator = this.djcross.getMeasures().iterator();
                while (iterator.hasNext()) {
                    JRDesignStyle jrstyle;
                    Style style;
                    boolean isTotalCell;
                    DJCrosstabMeasure djmeasure = (DJCrosstabMeasure)iterator.next();
                    JRDesignTextField element = new JRDesignTextField();
                    element.setWidth(crosstabColumn.getWidth());
                    element.setHeight(measureHeight);
                    element.setY(counter * measureHeight);
                    JRDesignExpression measureExp = new JRDesignExpression();
                    boolean bl2 = isTotalCell = isRowTotal || isColumnTotal;
                    if (!isTotalCell) {
                        if (djmeasure.getValueFormatter() == null) {
                            measureExp.setValueClassName(djmeasure.getProperty().getValueClassName());
                            measureExp.setText("$V{" + djmeasure.getProperty().getProperty() + "}");
                        } else {
                            measureExp.setText(djmeasure.getTextForValueFormatterExpression(djmeasure.getProperty().getProperty()));
                            measureExp.setValueClassName(djmeasure.getValueFormatter().getClassName());
                        }
                    } else if (djmeasure.getValueFormatter() == null) {
                        if (djmeasure.getPrecalculatedTotalProvider() == null) {
                            measureExp.setValueClassName(djmeasure.getProperty().getValueClassName());
                            measureExp.setText("$V{" + djmeasure.getProperty().getProperty() + "}");
                        } else {
                            this.setExpressionForPrecalculatedTotalValue(auxCols, auxRows, measureExp, djmeasure, crosstabColumn, crosstabRow);
                        }
                    } else if (djmeasure.getPrecalculatedTotalProvider() == null) {
                        measureExp.setValueClassName(djmeasure.getProperty().getValueClassName());
                        measureExp.setText("$V{" + djmeasure.getProperty().getProperty() + "}");
                    } else {
                        this.setExpressionForPrecalculatedTotalValue(auxCols, auxRows, measureExp, djmeasure, crosstabColumn, crosstabRow);
                    }
                    element.setExpression((JRExpression)measureExp);
                    if (!isRowTotal && !isColumnTotal && djmeasure.getStyle() != null) {
                        this.layoutManager.applyStyleToElement(djmeasure.getStyle(), (JRDesignElement)element);
                    }
                    if (isRowTotal && !isColumnTotal) {
                        style = this.getRowTotalStyle(crosstabRow);
                        if (style == null) {
                            style = djmeasure.getStyle();
                        }
                        if (style != null) {
                            this.layoutManager.applyStyleToElement(style, (JRDesignElement)element);
                        }
                    }
                    if (isColumnTotal && !isRowTotal) {
                        style = this.getColumnTotalStyle(crosstabColumn);
                        if (style == null) {
                            style = djmeasure.getStyle();
                        }
                        if (style != null) {
                            this.layoutManager.applyStyleToElement(style, (JRDesignElement)element);
                        }
                    }
                    if (isRowTotal && isColumnTotal) {
                        style = this.getRowTotalStyle(crosstabRow);
                        if (style == null) {
                            style = this.getColumnTotalStyle(crosstabColumn);
                        }
                        if (style == null) {
                            style = djmeasure.getStyle();
                        }
                        if (style != null) {
                            this.layoutManager.applyStyleToElement(style, (JRDesignElement)element);
                        }
                    }
                    if ((jrstyle = (JRDesignStyle)element.getStyle()) == null) {
                        if (log.isDebugEnabled()) {
                            log.warn((Object)"jrstyle is null in crosstab cell, this should have not happened.");
                        }
                        this.layoutManager.applyStyleToElement(null, (JRDesignElement)element);
                        jrstyle = (JRDesignStyle)element.getStyle();
                        jrstyle.setBlankWhenNull(true);
                    }
                    JRDesignStyle alternateStyle = Utils.cloneStyle(jrstyle);
                    alternateStyle.setName(alternateStyle.getFontName() + "_for_column_" + djmeasure.getProperty());
                    alternateStyle.getConditionalStyleList().clear();
                    element.setStyle((JRStyle)alternateStyle);
                    try {
                        this.design.addStyle((JRStyle)alternateStyle);
                    }
                    catch (JRException e) {
                        // empty catch block
                    }
                    this.setUpConditionStyles(alternateStyle, djmeasure, measureExp.getText());
                    if (djmeasure.getLink() != null) {
                        String name = "cell_" + i + "_" + j + "_ope" + djmeasure.getOperation().getValue();
                        HyperLinkUtil.applyHyperLinkToElement((DynamicJasperDesign)this.design, djmeasure.getLink(), element, name);
                    }
                    contents.addElement((JRDesignElement)element);
                    ++counter;
                }
                contents.setMode(new Byte(Transparency.OPAQUE.getValue()));
                this.applyBackgroundColor(contents, crosstabRow, crosstabColumn, i, j);
                this.applyCellBorder(contents);
                cell.setContents(contents);
                try {
                    this.jrcross.addCell(cell);
                    continue;
                }
                catch (JRException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void setExpressionForPrecalculatedTotalValue(DJCrosstabColumn[] auxCols, DJCrosstabRow[] auxRows, JRDesignExpression measureExp, DJCrosstabMeasure djmeasure, DJCrosstabColumn crosstabColumn, DJCrosstabRow crosstabRow) {
        String rowValuesExp = "new Object[]{";
        String rowPropsExp = "new String[]{";
        for (int i = 0; i < auxRows.length; ++i) {
            if (auxRows[i].getProperty() == null) continue;
            rowValuesExp = rowValuesExp + "$V{" + auxRows[i].getProperty().getProperty() + "}";
            rowPropsExp = rowPropsExp + "\"" + auxRows[i].getProperty().getProperty() + "\"";
            if (i + 1 >= auxRows.length || auxRows[i + 1].getProperty() == null) continue;
            rowValuesExp = rowValuesExp + ", ";
            rowPropsExp = rowPropsExp + ", ";
        }
        rowValuesExp = rowValuesExp + "}";
        rowPropsExp = rowPropsExp + "}";
        String colValuesExp = "new Object[]{";
        String colPropsExp = "new String[]{";
        for (int i = 0; i < auxCols.length; ++i) {
            if (auxCols[i].getProperty() == null) continue;
            colValuesExp = colValuesExp + "$V{" + auxCols[i].getProperty().getProperty() + "}";
            colPropsExp = colPropsExp + "\"" + auxCols[i].getProperty().getProperty() + "\"";
            if (i + 1 >= auxCols.length || auxCols[i + 1].getProperty() == null) continue;
            colValuesExp = colValuesExp + ", ";
            colPropsExp = colPropsExp + ", ";
        }
        colValuesExp = colValuesExp + "}";
        colPropsExp = colPropsExp + "}";
        String expText = "(((" + DJCRosstabMeasurePrecalculatedTotalProvider.class.getName() + ")$P{crosstab-measure__" + djmeasure.getProperty().getProperty() + "_totalProvider}).getValueFor( " + colPropsExp + ", " + colValuesExp + ", " + rowPropsExp + ", " + rowValuesExp + " ))";
        if (djmeasure.getValueFormatter() != null) {
            String fieldsMap = ExpressionUtils.getTextForFieldsFromScriptlet();
            String parametersMap = ExpressionUtils.getTextForParametersFromScriptlet();
            String variablesMap = ExpressionUtils.getTextForVariablesFromScriptlet();
            String stringExpression = "(((" + DJValueFormatter.class.getName() + ")$P{crosstab-measure__" + djmeasure.getProperty().getProperty() + "_vf}).evaluate( " + "(" + expText + "), " + fieldsMap + ", " + variablesMap + ", " + parametersMap + " ))";
            measureExp.setText(stringExpression);
            measureExp.setValueClassName(djmeasure.getValueFormatter().getClassName());
        } else {
            log.debug((Object)("text for crosstab total provider is: " + expText));
            measureExp.setText(expText);
            measureExp.setValueClassName(Number.class.getName());
        }
    }

    private void setUpConditionStyles(JRDesignStyle jrstyle, DJCrosstabMeasure djmeasure, String columExpression) {
        if (Utils.isEmpty(djmeasure.getConditionalStyles())) {
            return;
        }
        Iterator iterator = djmeasure.getConditionalStyles().iterator();
        while (iterator.hasNext()) {
            ConditionalStyle condition = (ConditionalStyle)iterator.next();
            JRDesignExpression expression = this.getExpressionForConditionalStyle(condition, columExpression);
            JRDesignConditionalStyle condStyle = this.layoutManager.makeConditionalStyle(condition.getStyle());
            condStyle.setConditionExpression((JRExpression)expression);
            jrstyle.addConditionalStyle((JRConditionalStyle)condStyle);
        }
    }

    protected JRDesignExpression getExpressionForConditionalStyle(ConditionalStyle condition, String columExpression) {
        String fieldsMap = "((" + DJDefaultScriptlet.class.getName() + ")$P{REPORT_SCRIPTLET}).getCurrentFiels()";
        String parametersMap = "((" + DJDefaultScriptlet.class.getName() + ")$P{REPORT_SCRIPTLET}).getCurrentParams()";
        String variablesMap = "((" + DJDefaultScriptlet.class.getName() + ")$P{REPORT_SCRIPTLET}).getCurrentVariables()";
        String evalMethodParams = fieldsMap + ", " + variablesMap + ", " + parametersMap + ", " + columExpression;
        String text = "((" + ConditionStyleExpression.class.getName() + ")$P{" + "REPORT_PARAMETERS_MAP" + "}.get(\"" + condition.getName() + "\"))." + "evaluate" + "(" + evalMethodParams + ")";
        JRDesignExpression expression = new JRDesignExpression();
        expression.setValueClass(Boolean.class);
        expression.setText(text);
        return expression;
    }

    private Style getRowTotalStyle(DJCrosstabRow crosstabRow) {
        return crosstabRow.getTotalStyle() == null ? this.djcross.getRowTotalStyle() : crosstabRow.getTotalStyle();
    }

    private Style getColumnTotalStyle(DJCrosstabColumn crosstabColumnRow) {
        return crosstabColumnRow.getTotalStyle() == null ? this.djcross.getColumnTotalStyle() : crosstabColumnRow.getTotalStyle();
    }

    private void applyBackgroundColor(JRDesignCellContents contents, DJCrosstabRow crosstabRow, DJCrosstabColumn crosstabColumn, int i, int j) {
        Color color = null;
        if (i != j || i == 0) {
            // empty if block
        }
        color = this.colors[i][j];
        contents.setBackcolor(color);
    }

    private void registerMeasures() {
        Iterator iterator = this.djcross.getMeasures().iterator();
        while (iterator.hasNext()) {
            JRDesignCrosstabParameter crosstabParameter;
            JRDesignParameter dparam;
            DJCrosstabMeasure djmeasure = (DJCrosstabMeasure)iterator.next();
            JRDesignCrosstabMeasure measure = new JRDesignCrosstabMeasure();
            measure.setName(djmeasure.getProperty().getProperty());
            measure.setCalculation(djmeasure.getOperation().getValue());
            measure.setValueClassName(djmeasure.getProperty().getValueClassName());
            JRDesignExpression valueExp = new JRDesignExpression();
            valueExp.setValueClassName(djmeasure.getProperty().getValueClassName());
            valueExp.setText("$F{" + djmeasure.getProperty().getProperty() + "}");
            measure.setValueExpression((JRExpression)valueExp);
            if (djmeasure.getValueFormatter() != null) {
                dparam = new JRDesignParameter();
                dparam.setName("crosstab-measure__" + measure.getName() + "_vf");
                dparam.setValueClassName((class$ar$com$fdvs$dj$domain$DJValueFormatter == null ? Dj2JrCrosstabBuilder.class$("ar.com.fdvs.dj.domain.DJValueFormatter") : class$ar$com$fdvs$dj$domain$DJValueFormatter).getName());
                crosstabParameter = new JRDesignCrosstabParameter();
                crosstabParameter.setName("crosstab-measure__" + measure.getName() + "_vf");
                crosstabParameter.setValueClassName((class$ar$com$fdvs$dj$domain$DJValueFormatter == null ? Dj2JrCrosstabBuilder.class$("ar.com.fdvs.dj.domain.DJValueFormatter") : class$ar$com$fdvs$dj$domain$DJValueFormatter).getName());
                log.debug((Object)("Registering value formatter parameter for property " + dparam.getName()));
                try {
                    this.design.addParameter((JRParameter)dparam);
                    this.jrcross.addParameter((JRCrosstabParameter)crosstabParameter);
                }
                catch (JRException e) {
                    throw new EntitiesRegistrationException(e.getMessage(), e);
                }
                ((DynamicJasperDesign)this.design).getParametersWithValues().put(dparam.getName(), djmeasure.getValueFormatter());
            }
            if (djmeasure.getPrecalculatedTotalProvider() != null) {
                dparam = new JRDesignParameter();
                dparam.setName("crosstab-measure__" + measure.getName() + "_totalProvider");
                dparam.setValueClassName((class$ar$com$fdvs$dj$domain$DJCRosstabMeasurePrecalculatedTotalProvider == null ? Dj2JrCrosstabBuilder.class$("ar.com.fdvs.dj.domain.DJCRosstabMeasurePrecalculatedTotalProvider") : class$ar$com$fdvs$dj$domain$DJCRosstabMeasurePrecalculatedTotalProvider).getName());
                crosstabParameter = new JRDesignCrosstabParameter();
                crosstabParameter.setName("crosstab-measure__" + measure.getName() + "_totalProvider");
                crosstabParameter.setValueClassName((class$ar$com$fdvs$dj$domain$DJCRosstabMeasurePrecalculatedTotalProvider == null ? Dj2JrCrosstabBuilder.class$("ar.com.fdvs.dj.domain.DJCRosstabMeasurePrecalculatedTotalProvider") : class$ar$com$fdvs$dj$domain$DJCRosstabMeasurePrecalculatedTotalProvider).getName());
                log.debug((Object)("Registering crosstab total provider parameter for property " + dparam.getName()));
                try {
                    this.design.addParameter((JRParameter)dparam);
                    this.jrcross.addParameter((JRCrosstabParameter)crosstabParameter);
                }
                catch (JRException e) {
                    throw new EntitiesRegistrationException(e.getMessage(), e);
                }
                ((DynamicJasperDesign)this.design).getParametersWithValues().put(dparam.getName(), djmeasure.getPrecalculatedTotalProvider());
            }
            try {
                this.jrcross.addMeasure(measure);
            }
            catch (JRException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void registerRows() {
        for (int i = 0; i < this.rows.length; ++i) {
            Style headerstyle;
            DJCrosstabRow crosstabRow = this.rows[i];
            JRDesignCrosstabRowGroup ctRowGroup = new JRDesignCrosstabRowGroup();
            ctRowGroup.setWidth(crosstabRow.getHeaderWidth());
            ctRowGroup.setName(crosstabRow.getProperty().getProperty());
            JRDesignCrosstabBucket rowBucket = new JRDesignCrosstabBucket();
            ctRowGroup.setBucket(rowBucket);
            JRDesignExpression bucketExp = ExpressionUtils.createExpression("$F{" + crosstabRow.getProperty().getProperty() + "}", crosstabRow.getProperty().getValueClassName());
            rowBucket.setExpression(bucketExp);
            JRDesignCellContents rowHeaderContents = new JRDesignCellContents();
            JRDesignTextField rowTitle = new JRDesignTextField();
            JRDesignExpression rowTitExp = new JRDesignExpression();
            rowTitExp.setValueClassName(crosstabRow.getProperty().getValueClassName());
            rowTitExp.setText("$V{" + crosstabRow.getProperty().getProperty() + "}");
            rowTitle.setExpression((JRExpression)rowTitExp);
            rowTitle.setWidth(crosstabRow.getHeaderWidth());
            int auxHeight = this.getRowHeaderMaxHeight(crosstabRow);
            rowTitle.setHeight(auxHeight);
            Style style = headerstyle = crosstabRow.getHeaderStyle() == null ? this.djcross.getRowHeaderStyle() : crosstabRow.getHeaderStyle();
            if (headerstyle != null) {
                this.layoutManager.applyStyleToElement(headerstyle, (JRDesignElement)rowTitle);
                rowHeaderContents.setBackcolor(headerstyle.getBackgroundColor());
            }
            rowHeaderContents.addElement((JRDesignElement)rowTitle);
            rowHeaderContents.setMode(new Byte(Transparency.OPAQUE.getValue()));
            this.applyCellBorder(rowHeaderContents);
            ctRowGroup.setHeader(rowHeaderContents);
            if (crosstabRow.isShowTotals()) {
                this.createRowTotalHeader(ctRowGroup, crosstabRow);
            }
            try {
                this.jrcross.addRowGroup(ctRowGroup);
                continue;
            }
            catch (JRException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private int getRowHeaderMaxHeight(DJCrosstabRow crosstabRow) {
        int auxHeight = crosstabRow.getHeight();
        boolean found = false;
        Iterator iterator = this.djcross.getRows().iterator();
        while (iterator.hasNext()) {
            DJCrosstabRow row = (DJCrosstabRow)iterator.next();
            if (!row.equals(crosstabRow) && !found) continue;
            found = true;
            if (row.equals(crosstabRow) || !row.isShowTotals()) continue;
            auxHeight += row.getHeight();
        }
        return auxHeight;
    }

    private void registerColumns() {
        for (int i = 0; i < this.cols.length; ++i) {
            Style headerstyle;
            DJCrosstabColumn crosstabColumn = this.cols[i];
            JRDesignCrosstabColumnGroup ctColGroup = new JRDesignCrosstabColumnGroup();
            ctColGroup.setName(crosstabColumn.getProperty().getProperty());
            ctColGroup.setHeight(crosstabColumn.getHeaderHeight());
            JRDesignCrosstabBucket bucket = new JRDesignCrosstabBucket();
            JRDesignExpression bucketExp = ExpressionUtils.createExpression("$F{" + crosstabColumn.getProperty().getProperty() + "}", crosstabColumn.getProperty().getValueClassName());
            bucket.setExpression(bucketExp);
            ctColGroup.setBucket(bucket);
            JRDesignCellContents colHeaerContent = new JRDesignCellContents();
            JRDesignTextField colTitle = new JRDesignTextField();
            JRDesignExpression colTitleExp = new JRDesignExpression();
            colTitleExp.setValueClassName(crosstabColumn.getProperty().getValueClassName());
            colTitleExp.setText("$V{" + crosstabColumn.getProperty().getProperty() + "}");
            colTitle.setExpression((JRExpression)colTitleExp);
            colTitle.setWidth(crosstabColumn.getWidth());
            colTitle.setHeight(crosstabColumn.getHeaderHeight());
            int auxWidth = this.calculateRowHeaderMaxWidth(crosstabColumn);
            colTitle.setWidth(auxWidth);
            Style style = headerstyle = crosstabColumn.getHeaderStyle() == null ? this.djcross.getColumnHeaderStyle() : crosstabColumn.getHeaderStyle();
            if (headerstyle != null) {
                this.layoutManager.applyStyleToElement(headerstyle, (JRDesignElement)colTitle);
                colHeaerContent.setBackcolor(headerstyle.getBackgroundColor());
            }
            colHeaerContent.addElement((JRDesignElement)colTitle);
            colHeaerContent.setMode(new Byte(Transparency.OPAQUE.getValue()));
            this.applyCellBorder(colHeaerContent);
            ctColGroup.setHeader(colHeaerContent);
            if (crosstabColumn.isShowTotals()) {
                this.createColumTotalHeader(ctColGroup, crosstabColumn);
            }
            try {
                this.jrcross.addColumnGroup(ctColGroup);
                continue;
            }
            catch (JRException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private int calculateRowHeaderMaxWidth(DJCrosstabColumn crosstabColumn) {
        int auxWidth = 0;
        boolean firstTime = true;
        ArrayList auxList = new ArrayList(this.djcross.getColumns());
        Collections.reverse(auxList);
        Iterator iterator = auxList.iterator();
        while (iterator.hasNext()) {
            DJCrosstabColumn col = (DJCrosstabColumn)iterator.next();
            if (col.equals(crosstabColumn)) {
                if (auxWidth != 0) break;
                auxWidth = col.getWidth();
                break;
            }
            if (firstTime) {
                auxWidth += col.getWidth();
                firstTime = false;
            }
            if (!col.isShowTotals()) continue;
            auxWidth += col.getWidth();
        }
        return auxWidth;
    }

    private void createRowTotalHeader(JRDesignCrosstabRowGroup ctRowGroup, DJCrosstabRow crosstabRow) {
        JRDesignCellContents totalHeaderContent = new JRDesignCellContents();
        ctRowGroup.setTotalHeader(totalHeaderContent);
        ctRowGroup.setTotalPosition((byte)2);
        Style totalHeaderstyle = crosstabRow.getTotalHeaderStyle() == null ? this.djcross.getRowTotalheaderStyle() : crosstabRow.getTotalHeaderStyle();
        totalHeaderContent.setMode(new Byte(Transparency.OPAQUE.getValue()));
        JRDesignTextField element = new JRDesignTextField();
        JRDesignExpression exp = ExpressionUtils.createExpression("\"Total " + crosstabRow.getTitle() + "\"", String.class);
        element.setExpression((JRExpression)exp);
        element.setHeight(crosstabRow.getHeight());
        if (totalHeaderstyle != null) {
            totalHeaderContent.setBackcolor(totalHeaderstyle.getBackgroundColor());
            this.layoutManager.applyStyleToElement(totalHeaderstyle, (JRDesignElement)element);
        }
        int auxWidth = 0;
        boolean found = false;
        Iterator iterator = this.djcross.getRows().iterator();
        while (iterator.hasNext()) {
            DJCrosstabRow row = (DJCrosstabRow)iterator.next();
            if (!row.equals(crosstabRow) && !found) continue;
            found = true;
            auxWidth += row.getHeaderWidth();
        }
        element.setWidth(auxWidth);
        this.applyCellBorder(totalHeaderContent);
        totalHeaderContent.addElement((JRDesignElement)element);
    }

    private void applyCellBorder(JRDesignCellContents cellContent) {
        if (this.djcross.getCellBorder() != null && !this.djcross.getCellBorder().equals(Border.NO_BORDER)) {
            JRBaseBox box = new JRBaseBox();
            box.setBottomBorder(this.djcross.getCellBorder().getValue());
            box.setRightBorder(this.djcross.getCellBorder().getValue());
            box.setBorderColor(Color.black);
            cellContent.setBox((JRBox)box);
        }
    }

    private void createColumTotalHeader(JRDesignCrosstabColumnGroup ctColGroup, DJCrosstabColumn crosstabColumn) {
        JRDesignCellContents totalHeaderContent = new JRDesignCellContents();
        ctColGroup.setTotalHeader(totalHeaderContent);
        ctColGroup.setTotalPosition((byte)2);
        Style totalHeaderstyle = crosstabColumn.getTotalHeaderStyle() == null ? this.djcross.getColumnTotalheaderStyle() : crosstabColumn.getTotalHeaderStyle();
        totalHeaderContent.setMode(new Byte(Transparency.OPAQUE.getValue()));
        JRDesignExpression exp = ExpressionUtils.createExpression("\"Total " + crosstabColumn.getTitle() + "\"", String.class);
        JRDesignTextField element = new JRDesignTextField();
        element.setExpression((JRExpression)exp);
        element.setWidth(crosstabColumn.getWidth());
        if (totalHeaderstyle != null) {
            this.layoutManager.applyStyleToElement(totalHeaderstyle, (JRDesignElement)element);
            totalHeaderContent.setBackcolor(totalHeaderstyle.getBackgroundColor());
        }
        int auxWidth = 0;
        boolean found = false;
        Iterator iterator = this.djcross.getColumns().iterator();
        while (iterator.hasNext()) {
            DJCrosstabColumn col = (DJCrosstabColumn)iterator.next();
            if (!col.equals(crosstabColumn) && !found) continue;
            found = true;
            auxWidth += col.getHeaderHeight();
        }
        element.setHeight(auxWidth);
        this.applyCellBorder(totalHeaderContent);
        totalHeaderContent.addElement((JRDesignElement)element);
    }
}

