/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.domain;

import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.DJBaseElement;
import ar.com.fdvs.dj.domain.DJCRosstabMeasurePrecalculatedTotalProvider;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJHyperLink;
import ar.com.fdvs.dj.domain.DJValueFormatter;
import ar.com.fdvs.dj.domain.DjBaseMMValueFormatter;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.util.ExpressionUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DJCrosstabMeasure
extends DJBaseElement {
    private static final Log logger = LogFactory.getLog(DJCrosstabMeasure.class);
    private static final long serialVersionUID = 10000L;
    private ColumnProperty property;
    private DJCalculation operation;
    private String title;
    private List conditionalStyles = new ArrayList();
    private DJValueFormatter valueFormatter;
    private DJCRosstabMeasurePrecalculatedTotalProvider precalculatedTotalProvider;
    private Boolean isPercentage = Boolean.FALSE;
    private Boolean visible = Boolean.TRUE;
    private Style style;
    private DJHyperLink link;

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public List getConditionalStyles() {
        return this.conditionalStyles;
    }

    public void setConditionalStyles(List conditionalStyles) {
        this.conditionalStyles = conditionalStyles;
    }

    public DJCrosstabMeasure(String propertyName, String className, DJCalculation operation, String title) {
        this.property = new ColumnProperty(propertyName, className);
        this.operation = operation;
        this.title = title;
    }

    public DJCrosstabMeasure(ColumnProperty measure, DJCalculation operation, String title) {
        this.property = measure;
        this.operation = operation;
        this.title = title;
    }

    public DJCrosstabMeasure() {
    }

    public ColumnProperty getProperty() {
        return this.property;
    }

    public void setProperty(ColumnProperty measure) {
        this.property = measure;
    }

    public DJCalculation getOperation() {
        return this.operation;
    }

    public void setOperation(DJCalculation operation) {
        this.operation = operation;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public DJHyperLink getLink() {
        return this.link;
    }

    public void setLink(DJHyperLink link) {
        this.link = link;
    }

    public DJValueFormatter getValueFormatter() {
        return this.valueFormatter;
    }

    public void setValueFormatter(DJValueFormatter valueFormatter) {
        this.valueFormatter = valueFormatter;
    }

    public String getTextForValueFormatterExpression(String variableName, List<DJCrosstabMeasure> measures) {
        String stringExpression = null;
        String fieldsMap = ExpressionUtils.getTextForFieldsFromScriptlet();
        String parametersMap = ExpressionUtils.getTextForParametersFromScriptlet();
        String variablesMap = ExpressionUtils.getTextForVariablesFromScriptlet();
        if (this.getValueFormatter() instanceof DjBaseMMValueFormatter) {
            DjBaseMMValueFormatter formatter = (DjBaseMMValueFormatter)DjBaseMMValueFormatter.class.cast(this.getValueFormatter());
            String[] propertyMeasures = new String[measures.size()];
            int i = 0;
            for (DJCrosstabMeasure measure : measures) {
                propertyMeasures[i] = measure.getProperty().getProperty();
                ++i;
            }
            formatter.setPropertyMeasures(propertyMeasures);
            String rowValuesExp = "new Object[]{";
            int measureIdx = 0;
            for (DJCrosstabMeasure djmeasure : measures) {
                if (djmeasure.getProperty() != null) {
                    rowValuesExp = rowValuesExp + "$V{" + djmeasure.getMeasureIdentifier(measureIdx) + "}";
                    rowValuesExp = rowValuesExp + ", ";
                }
                ++measureIdx;
            }
            rowValuesExp = rowValuesExp.substring(0, rowValuesExp.length() - 2);
            rowValuesExp = rowValuesExp + "}";
            stringExpression = "(((" + DjBaseMMValueFormatter.class.getName() + ")$P{crosstab-measure__" + variableName + "_vf}).evaluate( " + rowValuesExp + ", " + fieldsMap + ", " + variablesMap + ", " + parametersMap + " ))";
        } else {
            stringExpression = "(((" + DJValueFormatter.class.getName() + ")$P{crosstab-measure__" + variableName + "_vf}).evaluate( $V{" + variableName + "}, " + fieldsMap + ", " + variablesMap + ", " + parametersMap + " ))";
        }
        logger.debug((Object)("Expression for crosstab DJValueFormatter = " + stringExpression));
        return stringExpression;
    }

    public String getMeasureIdentifier(int idx) {
        String measurePrefix = this.getMeasurePrefix(idx);
        String measureProperty = measurePrefix + this.getProperty().getProperty();
        return measureProperty;
    }

    public String getMeasurePrefix(int idx) {
        return "idx" + idx + "_";
    }

    public DJCRosstabMeasurePrecalculatedTotalProvider getPrecalculatedTotalProvider() {
        return this.precalculatedTotalProvider;
    }

    public void setPrecalculatedTotalProvider(DJCRosstabMeasurePrecalculatedTotalProvider precalculatedTotalProvider) {
        this.precalculatedTotalProvider = precalculatedTotalProvider;
    }

    public Boolean getIsPercentage() {
        return this.isPercentage;
    }

    public void setIsPercentage(Boolean isPercentage) {
        this.isPercentage = isPercentage;
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }
}

