/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core.registration;

import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.core.registration.AbstractEntityRegistrationManager;
import ar.com.fdvs.dj.core.registration.EntitiesRegistrationException;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJValueFormatter;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.DJGroupVariable;
import ar.com.fdvs.dj.domain.entities.Entity;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.ExpressionColumn;
import ar.com.fdvs.dj.domain.entities.columns.PercentageColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import ar.com.fdvs.dj.util.LayoutUtils;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ColumnsGroupVariablesRegistrationManager
extends AbstractEntityRegistrationManager {
    private static final Log log = LogFactory.getLog(ColumnsGroupVariablesRegistrationManager.class);
    private String type;
    private String columnToGroupByProperty;

    public ColumnsGroupVariablesRegistrationManager(String type, String columnToGroupByProperty, DynamicJasperDesign jd, DynamicReport dr, LayoutManager layoutManager) {
        super(jd, dr, layoutManager);
        this.type = type;
        this.columnToGroupByProperty = columnToGroupByProperty;
    }

    @Override
    protected void registerEntity(Entity entity) {
        DJGroupVariable columnsGroupVariable = (DJGroupVariable)entity;
        try {
            String name = this.getDjd().getName() + "_" + columnsGroupVariable.getColumnToApplyOperation().getGroupVariableName(this.type, this.columnToGroupByProperty);
            columnsGroupVariable.setName(name);
            if (columnsGroupVariable.getValueExpression() == null) {
                JRDesignVariable jrVariable = (JRDesignVariable)this.transformEntity(entity);
                log.debug((Object)("registering group variable " + jrVariable.getName() + " (" + jrVariable.getValueClassName() + ")"));
                this.getDjd().addVariable(jrVariable);
                this.registerValueFormatter(columnsGroupVariable, jrVariable.getName());
            } else {
                this.registerCustomExpressionParameter(name + "_valueExpression", columnsGroupVariable.getValueExpression());
            }
            if (columnsGroupVariable.getPrintWhenExpression() != null) {
                this.registerCustomExpressionParameter(name + "_printWhenExpression", columnsGroupVariable.getPrintWhenExpression());
            }
            if (columnsGroupVariable.getLabel() != null && columnsGroupVariable.getLabel().getLabelExpression() != null) {
                this.registerCustomExpressionParameter(name + "_labelExpression", columnsGroupVariable.getLabel().getLabelExpression());
            }
        }
        catch (JRException e) {
            throw new EntitiesRegistrationException(e.getMessage(), e);
        }
    }

    protected void registerValueFormatter(DJGroupVariable djVariable, String variableName) {
        if (djVariable.getValueFormatter() == null) {
            return;
        }
        JRDesignParameter dparam = new JRDesignParameter();
        dparam.setName(variableName + "_vf");
        dparam.setValueClassName(DJValueFormatter.class.getName());
        log.debug((Object)("Registering value formatter parameter for property " + dparam.getName()));
        try {
            this.getDjd().addParameter((JRParameter)dparam);
        }
        catch (JRException e) {
            throw new EntitiesRegistrationException(e.getMessage(), e);
        }
        this.getDjd().getParametersWithValues().put(dparam.getName(), djVariable.getValueFormatter());
    }

    @Override
    protected Object transformEntity(Entity entity) {
        Class incrementerFactoryClass;
        AbstractColumn pcol;
        DJGroupVariable groupVariable = (DJGroupVariable)entity;
        AbstractColumn col = groupVariable.getColumnToApplyOperation();
        String variableName = groupVariable.getName();
        log.debug((Object)("transforming group variable " + variableName));
        DJCalculation op = groupVariable.getOperation();
        JRDesignExpression expression = new JRDesignExpression();
        List groupsList = this.getDjd().getGroupsList();
        JRDesignGroup registeredGroup = (JRDesignGroup)groupsList.get(groupsList.size() - 1);
        if (col instanceof ExpressionColumn && ((ExpressionColumn)col).getExpressionForCalculation() != null) {
            ExpressionColumn expcol = (ExpressionColumn)col;
            expression.setText(expcol.getTextForExpressionForCalculartion());
            expression.setValueClassName(expcol.getExpressionForCalculation().getClassName());
        } else if (col instanceof PercentageColumn) {
            pcol = (PercentageColumn)col;
            expression.setText(((PercentageColumn)pcol).getPercentageColumn().getTextForExpression());
            expression.setValueClassName(((PercentageColumn)pcol).getPercentageColumn().getValueClassNameForExpression());
            DJGroup djgroup = groupVariable.getGroup();
            registeredGroup = LayoutUtils.findParentJRGroup(djgroup, this.getDynamicReport(), this.getDjd(), this.getLayoutManager());
        } else if (col.getTextFormatter() != null) {
            pcol = (PropertyColumn)col;
            expression.setText("$F{" + ((PropertyColumn)pcol).getColumnProperty().getProperty() + "}");
            expression.setValueClassName(((PropertyColumn)pcol).getColumnProperty().getValueClassName());
        } else {
            expression.setText(col.getTextForExpression());
            expression.setValueClassName(col.getValueClassNameForExpression());
        }
        JRDesignVariable variable = new JRDesignVariable();
        variable.setExpression((JRExpression)expression);
        variable.setCalculation(CalculationEnum.getByValue((byte)groupVariable.getOperation().getValue()));
        variable.setName(variableName);
        variable.setResetType(ResetTypeEnum.GROUP);
        variable.setResetGroup((JRGroup)registeredGroup);
        String valueClassName = col.getVariableClassName(op);
        String initialExpression = col.getInitialExpression(op);
        variable.setValueClassName(valueClassName);
        if (initialExpression != null) {
            JRDesignExpression initialExp = new JRDesignExpression();
            initialExp.setText(initialExpression);
            initialExp.setValueClassName(valueClassName);
            variable.setInitialValueExpression((JRExpression)initialExp);
        }
        if ((incrementerFactoryClass = groupVariable.getIncrementerFactoryClass()) != null) {
            variable.setIncrementerFactoryClass(incrementerFactoryClass);
        }
        return variable;
    }
}

