/*
 * Decompiled with CFR 0.152.
 */
package ar.com.siripo.arcache.backend.jedis;

import ar.com.siripo.arcache.backend.ArcacheBackendClient;
import ar.com.siripo.arcache.util.DummyFuture;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import net.spy.memcached.CachedData;
import net.spy.memcached.transcoders.SerializingTranscoder;
import org.apache.commons.codec.binary.Base64;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCommands;
import redis.clients.jedis.ShardedJedis;

public class ArcacheJedisClient
implements ArcacheBackendClient {
    private JedisCommands jedisCommands;
    private SerializingTranscoder serializingTranscoder;

    public ArcacheJedisClient(Jedis jedis) {
        this.jedisCommands = jedis;
        this.initialize();
    }

    public ArcacheJedisClient(ShardedJedis shardedJedis) {
        this.jedisCommands = shardedJedis;
        this.initialize();
    }

    private void initialize() {
        this.serializingTranscoder = new SerializingTranscoder();
    }

    public Future<Boolean> asyncSet(String key, int ttlSeconds, Object value) {
        String vals = this.convertObjectToRedisString(value);
        String ret = this.jedisCommands.setex(key, ttlSeconds, vals);
        if (!"OK".equals(ret)) {
            return new DummyFuture((Object)false);
        }
        return new DummyFuture((Object)true);
    }

    public Future<Object> asyncGet(String key) {
        String r = this.jedisCommands.get(key);
        Object o = null;
        if (r != null) {
            o = this.convertRedisStringToObject(r);
        }
        return new DummyFuture(o);
    }

    protected String convertObjectToRedisString(Object vobj) {
        try {
            CachedData cd = this.serializingTranscoder.encode(vobj);
            byte[] q = cd.getData();
            int flags = cd.getFlags();
            ByteBuffer bb = ByteBuffer.allocate(q.length + 4);
            bb.putInt(flags);
            bb.put(q);
            return Base64.encodeBase64String((byte[])bb.array());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error enconding the value", e);
        }
    }

    protected Object convertRedisStringToObject(String redisString) {
        try {
            byte[] barr = Base64.decodeBase64((String)redisString);
            ByteBuffer bb = ByteBuffer.wrap(barr);
            int flags = bb.getInt();
            byte[] dbyte = new byte[bb.remaining()];
            System.arraycopy(barr, bb.position(), dbyte, 0, bb.remaining());
            CachedData cd = new CachedData(flags, dbyte, 0x1400000);
            return this.serializingTranscoder.decode(cd);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error deconding the value", e);
        }
    }
}

