/*
 * Decompiled with CFR 0.152.
 */
package ar.gabrielsuarez.glib.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class XCollection {
    @SafeVarargs
    public static <T> List<T> listOf(T ... values) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < values.length; ++i) {
            list.add(values[i]);
        }
        return list;
    }

    @SafeVarargs
    public static <T> Set<T> setOf(T ... values) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (int i = 0; i < values.length; ++i) {
            set.add(values[i]);
        }
        return set;
    }

    public static <T> T add(Collection<T> collection, T value) {
        if (collection != null) {
            collection.add(value);
        }
        return value;
    }

    public static <T> T add(Collection<T> collection, T value, Boolean condition) {
        if (collection != null && condition != null && condition.booleanValue()) {
            collection.add(value);
        }
        return value;
    }

    @SafeVarargs
    public static <T extends Comparable<T>> T min(T ... values) {
        Comparable min = null;
        for (T value : values) {
            if (value == null || min != null && min.compareTo(value) <= 0) continue;
            min = (Comparable)value;
        }
        return (T)min;
    }

    @SafeVarargs
    public static <T extends Comparable<T>> T max(T ... values) {
        Comparable max = null;
        for (T value : values) {
            if (value == null || max != null && max.compareTo(value) >= 0) continue;
            max = (Comparable)value;
        }
        return (T)max;
    }

    public static Boolean isEmpty(Object value) {
        return value == null || value.toString().isEmpty();
    }

    public static Boolean anyEmpty(Object ... values) {
        Boolean anyEmpty = false;
        for (Object objeto : values) {
            anyEmpty = anyEmpty | XCollection.isEmpty(objeto);
        }
        return anyEmpty;
    }

    public static Boolean allEmpty(Object ... values) {
        Boolean allEmpty = values.length > 0;
        for (Object objeto : values) {
            allEmpty = allEmpty & XCollection.isEmpty(objeto);
        }
        return allEmpty;
    }

    @SafeVarargs
    public static <T> T firstNonEmpty(T ... values) {
        for (T value : values) {
            if (XCollection.isEmpty(value).booleanValue()) continue;
            return value;
        }
        return null;
    }

    @SafeVarargs
    public static <T> T lastNonEmpty(T ... values) {
        T lastNonEmpty = null;
        for (T value : values) {
            if (XCollection.isEmpty(value).booleanValue()) continue;
            lastNonEmpty = value;
        }
        return lastNonEmpty;
    }

    @SafeVarargs
    public static <T> T firstNonNull(T ... values) {
        for (T value : values) {
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @SafeVarargs
    public static <T> T lastNonNull(T ... values) {
        T lastNonNull = null;
        for (T value : values) {
            if (value == null) continue;
            lastNonNull = value;
        }
        return lastNonNull;
    }
}

