/*
 * Decompiled with CFR 0.152.
 */
package ar.gabrielsuarez.glib.core;

import ar.gabrielsuarez.glib.G;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class XReflection {
    public static <T> T instance(Class<T> type, Object ... parameters) {
        try {
            Class<?>[] types = XReflection.types(parameters);
            Constructor<T> constructor = type.getConstructor(types);
            T instance = constructor.newInstance(parameters);
            return instance;
        }
        catch (Exception e) {
            throw G.runtimeException(e);
        }
    }

    public static Class<?>[] types(Object ... values) {
        Class[] types = new Class[values.length];
        Integer i = 0;
        while (i < values.length) {
            types[i.intValue()] = values[i] != null ? values[i].getClass() : null;
            i = i + 1;
        }
        return types;
    }

    public static String javaType(Object value) {
        if (value != null) {
            Class<?> type = value.getClass();
            String javaType = type.getCanonicalName();
            javaType = type == Float.class ? "java.math.BigDecimal" : javaType;
            javaType = type == Double.class ? "java.math.BigDecimal" : javaType;
            javaType = type == BigInteger.class ? "java.math.BigInteger" : javaType;
            javaType = type == BigDecimal.class ? "java.math.BigDecimal" : javaType;
            javaType = type == Date.class ? "java.util.Date" : javaType;
            javaType = type == java.sql.Date.class ? "java.sql.Date" : javaType;
            javaType = type == LocalDate.class ? "java.time.LocalDate" : javaType;
            String string = javaType = type == LocalDateTime.class ? "java.time.LocalDateTime" : javaType;
            if (type == String.class) {
                String string2 = (String)value;
                String dateFormat = G.dateFormat(string2);
                if (dateFormat != null) {
                    return G.dateFormatContainsTime(dateFormat) != false ? "java.time.LocalDateTime" : "java.time.LocalDate";
                }
                return "String";
            }
            return javaType;
        }
        return "java.lang.Object";
    }

    public static Field[] fields(Object object) {
        return XReflection.fields(object.getClass());
    }

    public static Field[] fields(Class<?> type) {
        Field[] fields;
        for (Field field : fields = type.getDeclaredFields()) {
            field.setAccessible(true);
        }
        return fields;
    }

    public static <T> Map<String, Field> fieldMap(Class<T> type) {
        LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
        for (Field field : XReflection.fields(type)) {
            map.put(field.getName(), field);
        }
        return map;
    }

    public static <T> T trimAllFields(T object) {
        try {
            for (Field field : XReflection.fields(object)) {
                Object value = field.get(object);
                if (value == null || !(value instanceof String)) continue;
                field.set(object, value.toString().trim());
            }
            return object;
        }
        catch (Exception e) {
            throw G.runtimeException(e);
        }
    }

    public static <T extends Iterable<?>> T trimAllFields(T objects) {
        if (objects != null) {
            for (Object object : objects) {
                XReflection.trimAllFields(object);
            }
        }
        return objects;
    }
}

