/*
 * Decompiled with CFR 0.152.
 */
package ar.gabrielsuarez.glib.data;

import ar.gabrielsuarez.glib.G;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Data {
    private Map<String, Object> map;
    private List<Object> list;

    public Data convertToMap() {
        this.map = this.map == null ? new LinkedHashMap() : this.map;
        this.list = null;
        return this;
    }

    public Data convertToList() {
        this.map = null;
        this.list = this.list == null ? new ArrayList() : this.list;
        return this;
    }

    public Data() {
        this.convertToMap();
    }

    public static Data fromData(Data data) {
        return new Data().load(data.raw());
    }

    public static Data fromMap(Map<String, Object> map) {
        return new Data().loadMap(map);
    }

    public static Data fromList(List<Object> list) {
        return new Data().loadList(list);
    }

    public static Data fromJson(String json) {
        return new Data().loadJson(json);
    }

    public static Data fromXml(String xml) {
        return new Data().loadXml(xml);
    }

    public static Data fromYaml(String yaml) {
        return new Data().loadYaml(yaml);
    }

    private Data load(Object object) {
        if (object instanceof Map) {
            this.convertToMap().map.putAll((Map)object);
        }
        if (object instanceof List) {
            this.convertToList().list.addAll((List)object);
        }
        return this;
    }

    public Data loadData(Data data) {
        return this.load(data.raw());
    }

    public Data loadMap(Map<String, Object> map) {
        return this.load(map);
    }

    public Data loadList(List<Object> list) {
        return this.load(list);
    }

    public Data loadJson(String json) {
        return this.load(json != null && !json.isEmpty() ? G.fromJson(json) : null);
    }

    public Data loadXml(String xml) {
        return this.load(xml != null && !xml.isEmpty() ? G.fromXml(xml) : null);
    }

    public Data loadYaml(String yaml) {
        return this.load(yaml != null && !yaml.isEmpty() ? G.fromYaml(yaml) : null);
    }

    public Map<String, Object> toMap() {
        return this.map != null ? new LinkedHashMap<String, Object>(this.map) : new LinkedHashMap();
    }

    public List<Object> toList() {
        return this.list != null ? new ArrayList<Object>(this.list) : new ArrayList();
    }

    public String toJson() {
        return G.toJson(this);
    }

    public String toJsonSingleLine() {
        return G.toJsonSingleLine(this);
    }

    public String toXml(String root) {
        return G.toXml(this, root);
    }

    public String toXmlSingleLine(String root) {
        return G.toXmlSingleLine(this, root);
    }

    public String toYaml() {
        return G.toYaml(this);
    }

    public <T> T toClass(Class<T> type) {
        return G.fromJson(this.toJson(), type);
    }

    public Object get(String key) {
        String[] subkeys;
        Object current = this;
        for (String subkey : subkeys = key.split("\\.")) {
            current = this.getSubKey(current, subkey);
        }
        return current;
    }

    private Object getSubKey(Object context, String subkey) {
        Object object = context = context instanceof Data ? ((Data)context).raw() : context;
        if (context instanceof Map) {
            Map current = (Map)context;
            return current.get(subkey);
        }
        if (context instanceof List) {
            List current = (List)context;
            Integer index = G.toInteger(subkey);
            if (index != null && current.size() > index && index >= 0) {
                return current.get(index);
            }
        }
        return null;
    }

    public Data set(String key) {
        Data data = new Data();
        this.set(key, data);
        return data;
    }

    public Data set(String key, Object value) {
        Object current = this;
        String[] subkeys = key.split("\\.");
        for (int i = 0; i < subkeys.length; ++i) {
            current = i + 1 == subkeys.length ? this.setSubKey(current, subkeys[i], value) : this.setSubKey(current, subkeys[i]);
        }
        return this;
    }

    public Data set(String key, Object value, Boolean condition) {
        if (condition.booleanValue()) {
            return this.set(key, value);
        }
        return this;
    }

    private Object setSubKey(Object context, String subkey) {
        Object next = this.getSubKey(context, subkey);
        if (next == null) {
            next = new Data();
            Object object = context = context instanceof Data ? ((Data)context).raw() : context;
            if (context instanceof Map) {
                Map current = (Map)context;
                current.put(subkey, next);
            } else if (context instanceof List) {
                List current = (List)context;
                Integer index = G.toInteger(subkey);
                if (index != null) {
                    Integer size = current.size();
                    for (int i = size.intValue(); i <= index; ++i) {
                        current.add(null);
                    }
                    current.set(index, next);
                }
            }
        }
        return next;
    }

    private Object setSubKey(Object context, String subkey, Object value) {
        Integer index = G.toInteger(subkey);
        if (context instanceof Data) {
            Object object = context = index == null ? ((Data)context).raw() : ((Data)context).convertToList().raw();
        }
        if (context instanceof Map) {
            Map current = (Map)context;
            current.put(subkey, value);
        } else if (context instanceof List) {
            List current = (List)context;
            Integer size = current.size();
            for (int i = size.intValue(); i <= index; ++i) {
                current.add(null);
            }
            if (index >= 0) {
                current.set(index, value);
            }
        }
        return null;
    }

    public Object raw() {
        Object object = null;
        object = this.map != null ? this.map : object;
        object = this.list != null ? this.list : object;
        return object;
    }

    public Object object(String key) {
        return this.object(key, null);
    }

    public Object object(String key, Object defaultValue) {
        Object object = this.get(key);
        return object != null ? object : defaultValue;
    }

    public Data data(String key) {
        return this.data(key, null);
    }

    public Data data(String key, Data defaultValue) {
        Object object = this.object(key);
        if (object instanceof Data) {
            return (Data)object;
        }
        if (object instanceof Map) {
            return Data.fromMap((Map)object);
        }
        if (object instanceof Data) {
            return Data.fromList((List)object);
        }
        return defaultValue;
    }

    public Map<String, Object> map(String key) {
        return this.map(key, null);
    }

    public Map<String, Object> map(String key, Map<String, Object> defaultValue) {
        Object object = this.object(key);
        if (object instanceof Data) {
            return ((Data)object).map;
        }
        if (object instanceof Map) {
            return (Map)object;
        }
        return defaultValue;
    }

    public List<Object> list(String key) {
        return this.list(key, null);
    }

    public List<Object> list(String key, List<Object> defaultValue) {
        Object object = this.object(key);
        if (object instanceof Data) {
            return ((Data)object).list;
        }
        if (object instanceof List) {
            return (List)object;
        }
        return defaultValue;
    }

    public String string(String key) {
        return this.string(key, null);
    }

    public String string(String key, String defaultValue) {
        Object object = this.object(key);
        return object != null ? object.toString() : defaultValue;
    }

    public Boolean bool(String key) {
        return this.bool(key, null);
    }

    public Boolean bool(String key, Boolean defaultValue) {
        return G.toBoolean(this.string(key), defaultValue);
    }

    public Short shortInt(String key) {
        return this.shortInt(key, null);
    }

    public Short shortInt(String key, Short defaultValue) {
        return G.toShort(this.string(key), defaultValue);
    }

    public Integer integer(String key) {
        return this.integer(key, null);
    }

    public Integer integer(String key, Integer defaultValue) {
        return G.toInteger(this.string(key), defaultValue);
    }

    public Long longInt(String key) {
        return this.longInt(key, null);
    }

    public Long longInt(String key, Long defaultValue) {
        return G.toLong(this.string(key), defaultValue);
    }

    public Float floatNumber(String key) {
        return this.floatNumber(key, null);
    }

    public Float floatNumber(String key, Float defaultValue) {
        return G.toFloat(this.string(key), defaultValue);
    }

    public Double doubleNumber(String key) {
        return this.doubleNumber(key, null);
    }

    public Double doubleNumber(String key, Double defaultValue) {
        return G.toDouble(this.string(key), defaultValue);
    }

    public BigInteger bigInteger(String key) {
        return this.bigInteger(key, null);
    }

    public BigInteger bigInteger(String key, BigInteger defaultValue) {
        return G.toBigInteger(this.string(key), defaultValue);
    }

    public BigDecimal bigDecimal(String key) {
        return this.bigDecimal(key, null);
    }

    public BigDecimal bigDecimal(String key, BigDecimal defaultValue) {
        return G.toBigDecimal(this.string(key), defaultValue);
    }

    public String toString() {
        return this.toJson();
    }
}

