/*
 * Decompiled with CFR 0.152.
 */
package ar.gabrielsuarez.glib.web;

import ar.gabrielsuarez.glib.G;
import ar.gabrielsuarez.glib.web.WebContext;
import ar.gabrielsuarez.glib.web.WebServer;
import java.util.function.Function;
import spark.Request;
import spark.Response;
import spark.Route;

public abstract class WebApplication<T extends WebContext> {
    private WebServer server;
    private Class<T> contextType;

    void setServer(WebServer server) {
        this.server = server;
    }

    void setContextType(Class<T> contextType) {
        this.contextType = contextType;
    }

    protected void any(String path, Function<T, Object> funcion) {
        this.get(path, funcion);
        this.post(path, funcion);
        this.put(path, funcion);
        this.patch(path, funcion);
        this.delete(path, funcion);
    }

    protected void get(String path, Function<T, Object> funcion) {
        this.server.get(path, this.process(funcion));
    }

    protected void post(String path, Function<T, Object> funcion) {
        this.server.post(path, this.process(funcion));
    }

    protected void put(String path, Function<T, Object> funcion) {
        this.server.put(path, this.process(funcion));
    }

    protected void patch(String path, Function<T, Object> funcion) {
        this.server.patch(path, this.process(funcion));
    }

    protected void delete(String path, Function<T, Object> funcion) {
        this.server.delete(path, this.process(funcion));
    }

    protected void head(String path, Function<T, Object> funcion) {
        this.server.head(path, this.process(funcion));
    }

    protected void trace(String path, Function<T, Object> funcion) {
        this.server.trace(path, this.process(funcion));
    }

    protected void connect(String path, Function<T, Object> funcion) {
        this.server.connect(path, this.process(funcion));
    }

    protected void options(String path, Function<T, Object> funcion) {
        this.server.options(path, this.process(funcion));
    }

    private Route process(final Function<T, Object> function) {
        Route route = new Route(){

            public Object handle(Request sparkRequest, Response sparkResponse) {
                WebContext context = (WebContext)G.instance(WebApplication.this.contextType);
                context.setRequest(sparkRequest);
                context.setResponse(sparkResponse);
                context.parameters.load(sparkRequest);
                context.init();
                try {
                    WebApplication.this.before(context);
                    if (!context.response.isReady().booleanValue()) {
                        Object body = function.apply(context);
                        context.response.setBody(body);
                    }
                    if (!context.response.isReady().booleanValue()) {
                        WebApplication.this.after(context);
                    }
                }
                catch (Exception e) {
                    context.response.setHttpCode(500);
                    WebApplication.this.exception(context, e);
                }
                sparkResponse.status(context.response.httpCode().intValue());
                for (String header : context.response.headers()) {
                    sparkResponse.header(header, context.response.header(header));
                }
                if (context.isGzipEnabled().booleanValue()) {
                    sparkResponse.header("Content-Encoding", "gzip");
                }
                return context.response.body();
            }
        };
        return route;
    }

    protected abstract void init();

    protected abstract void endpoints();

    protected abstract void before(T var1);

    protected abstract void after(T var1);

    protected abstract void exception(T var1, Exception var2);
}

