/*
 * Decompiled with CFR 0.152.
 */
package ar.gabrielsuarez.glib.web;

import ar.gabrielsuarez.glib.web.WebParameters;
import ar.gabrielsuarez.glib.web.WebResponse;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import spark.Request;
import spark.Response;

public abstract class WebContext {
    private Request sparkRequest;
    private Response sparkResponse;
    public WebParameters parameters = new WebParameters();
    public WebResponse response = new WebResponse();

    public abstract void init();

    void setRequest(Request request) {
        this.sparkRequest = request;
    }

    void setResponse(Response response) {
        this.sparkResponse = response;
    }

    public HttpServletRequest request() {
        return this.sparkRequest != null ? this.sparkRequest.raw() : null;
    }

    public HttpServletResponse response() {
        return this.sparkResponse != null ? this.sparkResponse.raw() : null;
    }

    public Set<String> requestHeaders() {
        return this.sparkRequest != null ? this.sparkRequest.headers() : new HashSet();
    }

    public String requestHeader(String header) {
        return this.requestHeader(header, "");
    }

    public String requestHeader(String header, String defaultValue) {
        String value = this.sparkRequest != null ? this.sparkRequest.headers(header) : null;
        return value != null ? value : defaultValue;
    }

    public String uri() {
        return this.sparkRequest != null ? this.sparkRequest.uri() : null;
    }

    public String ip() {
        String ip = null;
        if (this.sparkRequest != null) {
            String xForwardedFor = this.requestHeader("x-forwarded-for");
            ip = !xForwardedFor.isEmpty() ? xForwardedFor.split(",")[0].trim() : this.sparkRequest.ip();
        }
        return ip;
    }

    public String userAgent() {
        return this.requestHeader("user-agent");
    }

    public Boolean isGzipEnabled() {
        String[] tokens;
        String acceptEncoding = this.requestHeader("Accept-Encoding");
        if (!acceptEncoding.isEmpty() && Arrays.stream(tokens = acceptEncoding.split(",")).map(String::trim).anyMatch(s -> s.equalsIgnoreCase("gzip"))) {
            return true;
        }
        return false;
    }
}

