/*
 * Decompiled with CFR 0.152.
 */
package ar.gabrielsuarez.glib.web;

import ar.gabrielsuarez.glib.G;
import ar.gabrielsuarez.glib.data.Data;
import ar.gabrielsuarez.glib.data.DataFile;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.MultipartConfigElement;
import javax.servlet.http.Part;
import spark.Request;

public class WebParameters
extends Data {
    private Map<String, DataFile> files = new LinkedHashMap<String, DataFile>();

    WebParameters load(Request request) {
        this.loadPath(request);
        this.loadQueryAndForm(request);
        this.loadBody(request);
        this.loadMultipart(request);
        return this;
    }

    private void loadPath(Request request) {
        for (String pathParam : request.params().keySet()) {
            this.set(pathParam, request.params(pathParam));
        }
    }

    private void loadQueryAndForm(Request request) {
        for (String queryParam : request.queryParams()) {
            this.set(queryParam, request.queryParams(queryParam));
        }
    }

    private void loadBody(Request request) {
        if (!this.isMultipart(request).booleanValue()) {
            String body = request.body();
            try {
                if (G.posibleJson(body).booleanValue()) {
                    this.loadJson(body);
                } else if (G.posibleXml(body).booleanValue()) {
                    this.loadXml(body);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void loadMultipart(Request request) {
        try {
            if (this.isMultipart(request).booleanValue()) {
                request.attribute("org.eclipse.jetty.multipartConfig", (Object)new MultipartConfigElement(G.tmpPath()));
                for (Part part : request.raw().getParts()) {
                    String key = part.getName();
                    String fileName = part.getSubmittedFileName();
                    if (fileName == null) {
                        String value = G.toString(part.getInputStream());
                        this.set(key, value);
                        continue;
                    }
                    byte[] bytes = G.toBytes(part.getInputStream());
                    DataFile file = new DataFile(fileName, bytes);
                    this.files.put(key, file);
                }
            }
        }
        catch (Exception e) {
            throw G.runtimeException(e);
        }
    }

    public Set<String> files() {
        return this.files.keySet();
    }

    public DataFile file(String fileName) {
        return this.files.get(fileName);
    }

    private Boolean isMultipart(Request request) {
        String contentType = request.headers("Content-Type");
        return contentType != null && contentType.contains("multipart/form-data");
    }

    @Override
    public String toString() {
        Data data = Data.fromData(this);
        for (String key : this.files.keySet()) {
            String value = "[binary:" + this.files.get((Object)key).bytes.length + "]";
            data.set(key, value);
        }
        return data.toString();
    }
}

