/*
 * Decompiled with CFR 0.152.
 */
package ar.gabrielsuarez.glib.web;

import ar.gabrielsuarez.glib.G;
import ar.gabrielsuarez.glib.web.WebApplication;
import ar.gabrielsuarez.glib.web.WebContext;
import java.util.ArrayList;
import java.util.List;
import spark.Route;
import spark.Service;

public class WebServer {
    private Service http = Service.ignite();
    private List<WebApplication<?>> applications = new ArrayList();

    public void run(Integer port) {
        this.http.port(port.intValue());
        for (WebApplication<?> aplicacion : this.applications) {
            aplicacion.endpoints();
        }
        this.http.init();
        this.http.awaitInitialization();
        for (WebApplication<?> aplicacion : this.applications) {
            aplicacion.init();
        }
    }

    public <A extends WebApplication<C>, C extends WebContext> void register(Class<A> applicationType, Class<C> contextType) {
        WebApplication application = (WebApplication)G.instance(applicationType);
        application.setServer(this);
        application.setContextType(contextType);
        this.applications.add(application);
    }

    public void staticFiles(String path) {
        this.http.staticFileLocation(path);
    }

    void get(String path, Route route) {
        this.http.get(path, route);
    }

    void post(String path, Route route) {
        this.http.post(path, route);
    }

    void put(String path, Route route) {
        this.http.put(path, route);
    }

    void patch(String path, Route route) {
        this.http.patch(path, route);
    }

    void delete(String path, Route route) {
        this.http.delete(path, route);
    }

    void head(String path, Route route) {
        this.http.head(path, route);
    }

    void trace(String path, Route route) {
        this.http.trace(path, route);
    }

    void connect(String path, Route route) {
        this.http.connect(path, route);
    }

    void options(String path, Route route) {
        this.http.options(path, route);
    }
}

