/*
 * Decompiled with CFR 0.152.
 */
package ar.gabrielsuarez.glib.core;

import ar.gabrielsuarez.glib.G;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class Resource {
    public static InputStream resourceInputStream(String path) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
    }

    public static byte[] resourceBytes(String path) {
        return G.toBytes(Resource.resourceInputStream(path));
    }

    public static String resourceBase64(String path) {
        return G.base64(Resource.resourceBytes(path));
    }

    public static Properties properties(String path) {
        Properties properties = new Properties();
        try (InputStream is = Resource.resourceInputStream(path);){
            properties.load(is);
        }
        catch (Exception e) {
            throw G.runtimeException(e);
        }
        return properties;
    }

    public static Map<String, String> propertiesToMap(String path) {
        HashMap<String, String> map = new HashMap<String, String>();
        Properties properties = Resource.properties(path);
        for (Object key : properties.keySet()) {
            map.put(key.toString(), properties.getProperty(key.toString()).trim());
        }
        return map;
    }
}

