/*
 * Decompiled with CFR 0.152.
 */
package ar.gabrielsuarez.glib.core;

import ar.gabrielsuarez.glib.G;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;

public abstract class Serializer {
    protected static JsonMapper jsonMapper = new JsonMapper();
    protected static XmlMapper xmlMapper = new XmlMapper();
    protected static YAMLMapper yamlMapper = new YAMLMapper();

    protected static void configure(ObjectMapper mapper) {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.registerModule((Module)Serializer.module());
    }

    protected static SimpleModule module() {
        SimpleModule simpleModule = new SimpleModule();
        return simpleModule;
    }

    public static <T> T fromMap(Map<String, Object> map, Class<T> type) {
        return Serializer.fromJson(Serializer.toJson(map), type);
    }

    public static Map<String, Object> toMap(Object object) {
        return Serializer.fromJson(Serializer.toJson(object), Map.class);
    }

    public static Object fromJson(String json) {
        return Serializer.fromJson(json, Object.class);
    }

    public static <T> T fromJson(String json, Class<T> type) {
        try {
            return (T)jsonMapper.readValue(json, type);
        }
        catch (Exception e) {
            throw new SerializerException(e);
        }
    }

    public static String toJson(Object object) {
        try {
            return jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (Exception e) {
            throw new SerializerException(e);
        }
    }

    public static String toJsonSingleLine(Object object) {
        try {
            return jsonMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new SerializerException(e);
        }
    }

    public static Object fromXml(String xml) {
        return Serializer.fromXml(xml, Object.class);
    }

    public static <T> T fromXml(String xml, Class<T> type) {
        try {
            return (T)xmlMapper.readValue(xml, type);
        }
        catch (Exception e) {
            throw new SerializerException(e);
        }
    }

    public static String toXml(Object object, String root) {
        try {
            return xmlMapper.writerWithDefaultPrettyPrinter().withRootName(root).writeValueAsString(object);
        }
        catch (Exception e) {
            throw new SerializerException(e);
        }
    }

    public static String toXmlSingleLine(Object object, String root) {
        try {
            return xmlMapper.writer().withRootName(root).writeValueAsString(object);
        }
        catch (Exception e) {
            throw new SerializerException(e);
        }
    }

    public static Object fromYaml(String yaml) {
        return Serializer.fromYaml(yaml, Object.class);
    }

    public static <T> T fromYaml(String yaml, Class<T> type) {
        try {
            return (T)yamlMapper.readValue(yaml, type);
        }
        catch (Exception e) {
            throw new SerializerException(e);
        }
    }

    public static String toYaml(Object object) {
        try {
            return yamlMapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (Exception e) {
            throw new SerializerException(e);
        }
    }

    public static byte[] toBytes(Serializable object) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(object);
            oos.flush();
            byte[] data = bos.toByteArray();
            return data;
        }
        catch (Exception e) {
            throw G.runtimeException(e);
        }
    }

    public static <T> T toClass(Class<T> type, byte[] bytes) {
        return (T)Serializer.toObject(bytes);
    }

    public static Object toObject(byte[] bytes) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            ObjectInputStream is = new ObjectInputStream(in);
            Object object = is.readObject();
            return object;
        }
        catch (Exception e) {
            throw G.runtimeException(e);
        }
    }

    static {
        Serializer.configure((ObjectMapper)jsonMapper);
        Serializer.configure((ObjectMapper)xmlMapper);
        Serializer.configure((ObjectMapper)yamlMapper);
    }

    public static class SerializerException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public SerializerException(Exception e) {
            super(e);
        }
    }
}

