/*
 * Decompiled with CFR 0.152.
 */
package ar.gabrielsuarez.glib.core;

import ar.gabrielsuarez.glib.G;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public abstract class Convert {
    public static Map<Class<?>, Function<Object[], ?>> castMap = new HashMap();

    public static <T> T cast(Class<T> type, Object ... values) {
        Function<Object[], ?> function = castMap.get(type);
        if (function != null) {
            return (T)function.apply(values);
        }
        return null;
    }

    public static String toString(Object ... values) {
        return Convert.convert(values, String.class, x -> x.toString());
    }

    public static Boolean toBoolean(Object ... values) {
        return Convert.convert(values, Boolean.class, x -> {
            String string = x.toString().toLowerCase();
            Boolean data = null;
            data = data == null && "true".equals(string) ? Boolean.TRUE : data;
            data = data == null && "y".equals(string) ? Boolean.TRUE : data;
            data = data == null && "s".equals(string) ? Boolean.TRUE : data;
            data = data == null && "1".equals(string) ? Boolean.TRUE : data;
            data = data == null && "false".equals(string) ? Boolean.FALSE : data;
            data = data == null && "n".equals(string) ? Boolean.FALSE : data;
            data = data == null && "0".equals(string) ? Boolean.FALSE : data;
            return data;
        });
    }

    public static Short toShort(Object ... values) {
        return Convert.convert(values, Short.class, x -> Short.valueOf(x.toString()));
    }

    public static Integer toInteger(Object ... values) {
        return Convert.convert(values, Integer.class, x -> Integer.valueOf(x.toString()));
    }

    public static Long toLong(Object ... values) {
        return Convert.convert(values, Long.class, x -> Long.valueOf(x.toString()));
    }

    public static Float toFloat(Object ... values) {
        return Convert.convert(values, Float.class, x -> Float.valueOf(x.toString()));
    }

    public static Double toDouble(Object ... values) {
        return Convert.convert(values, Double.class, x -> Double.valueOf(x.toString()));
    }

    public static BigInteger toBigInteger(Object ... values) {
        return Convert.convert(values, BigInteger.class, x -> new BigInteger(x.toString()));
    }

    public static BigDecimal toBigDecimal(Object ... values) {
        return Convert.convert(values, BigDecimal.class, x -> new BigDecimal(x.toString()));
    }

    public static java.util.Date toDate(Object ... values) {
        return Convert.convert(values, java.util.Date.class, x -> {
            String value;
            String dateFormat;
            if (x instanceof java.util.Date) {
                return (java.util.Date)x;
            }
            if (x instanceof TemporalAccessor) {
                return java.util.Date.from(Instant.from((TemporalAccessor)x).atZone(ZoneId.systemDefault()).toInstant());
            }
            if (x instanceof String && (dateFormat = G.dateFormat(value = (String)x)) != null) {
                SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
                try {
                    return sdf.parse(value);
                }
                catch (Exception e) {
                    return null;
                }
            }
            return null;
        });
    }

    public static Date toSqlDate(Object ... values) {
        return Convert.convert(values, Date.class, x -> {
            String value;
            String dateFormat;
            if (x instanceof java.util.Date) {
                return new Date(((java.util.Date)x).getTime());
            }
            if (x instanceof TemporalAccessor) {
                java.util.Date date = java.util.Date.from(Instant.from((TemporalAccessor)x).atZone(ZoneId.systemDefault()).toInstant());
                return new Date(date.getTime());
            }
            if (x instanceof String && (dateFormat = G.dateFormat(value = (String)x)) != null) {
                SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
                try {
                    java.util.Date date = sdf.parse(value);
                    return new Date(date.getTime());
                }
                catch (Exception e) {
                    return null;
                }
            }
            return null;
        });
    }

    public static LocalDate toLocalDate(Object ... values) {
        return Convert.convert(values, LocalDate.class, x -> {
            String value;
            String dateFormat;
            if (x instanceof java.util.Date) {
                return ((java.util.Date)x).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            }
            if (x instanceof TemporalAccessor) {
                return LocalDate.from((TemporalAccessor)x);
            }
            if (x instanceof String && (dateFormat = G.dateFormat(value = (String)x)) != null) {
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern(dateFormat);
                try {
                    return LocalDate.parse(value, dtf);
                }
                catch (Exception e) {
                    return null;
                }
            }
            return null;
        });
    }

    public static LocalDateTime toLocalDateTime(Object ... values) {
        return Convert.convert(values, LocalDateTime.class, x -> {
            String value;
            String dateFormat;
            if (x instanceof java.util.Date) {
                return ((java.util.Date)x).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            }
            if (x instanceof TemporalAccessor) {
                return LocalDateTime.from((TemporalAccessor)x);
            }
            if (x instanceof String && (dateFormat = G.dateFormat(value = (String)x)) != null) {
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern(dateFormat);
                try {
                    return LocalDateTime.parse(value, dtf);
                }
                catch (Exception e) {
                    return null;
                }
            }
            return null;
        });
    }

    protected static <T> T convert(Object[] values, Class<T> type, Function<Object, T> function) {
        if (values != null) {
            for (Object value : values) {
                if (value == null) continue;
                if (value.getClass().equals(type)) {
                    return (T)value;
                }
                try {
                    T data = function.apply(value);
                    if (data != null) {
                        return data;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    static {
        castMap.put(String.class, values -> Convert.toString(values));
        castMap.put(Boolean.class, values -> Convert.toBoolean(values));
        castMap.put(Short.class, values -> Convert.toShort(values));
        castMap.put(Integer.class, values -> Convert.toInteger(values));
        castMap.put(Long.class, values -> Convert.toLong(values));
        castMap.put(Float.class, values -> Convert.toFloat(values));
        castMap.put(Double.class, values -> Convert.toDouble(values));
        castMap.put(BigInteger.class, values -> Convert.toBigInteger(values));
        castMap.put(BigDecimal.class, values -> Convert.toBigDecimal(values));
        castMap.put(java.util.Date.class, values -> Convert.toDate(values));
        castMap.put(Date.class, values -> Convert.toSqlDate(values));
        castMap.put(LocalDate.class, values -> Convert.toLocalDate(values));
        castMap.put(LocalDateTime.class, values -> Convert.toLocalDateTime(values));
    }
}

