/*
 * Decompiled with CFR 0.152.
 */
package ar.gabrielsuarez.glib.core;

import ar.gabrielsuarez.glib.G;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class Reflection {
    public static <T> T instance(Class<T> type, Object ... parameters) {
        try {
            Class<?>[] types = Reflection.types(parameters);
            Constructor<T> constructor = type.getConstructor(types);
            T instance = constructor.newInstance(parameters);
            return instance;
        }
        catch (Exception e) {
            throw G.runtimeException(e);
        }
    }

    public static Class<?>[] types(Object ... values) {
        Class[] types = new Class[values.length];
        if (values != null) {
            Integer i = 0;
            while (i < values.length) {
                types[i.intValue()] = values[i] != null ? values[i].getClass() : null;
                i = i + 1;
            }
        }
        return types;
    }

    public static Field[] fields(Object object) {
        return Reflection.fields(object.getClass());
    }

    public static Field[] fields(Class<?> type) {
        Field[] fields;
        for (Field field : fields = type.getDeclaredFields()) {
            field.setAccessible(true);
        }
        return fields;
    }

    public static <T> Map<String, Field> fieldMap(Class<T> type) {
        LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
        for (Field field : Reflection.fields(type)) {
            map.put(field.getName(), field);
        }
        return map;
    }

    public static <T> T trimAllFields(T object) {
        try {
            for (Field field : Reflection.fields(object)) {
                Object value = field.get(object);
                if (value == null || !(value instanceof String)) continue;
                field.set(object, value.toString().trim());
            }
            return object;
        }
        catch (Exception e) {
            throw G.runtimeException(e);
        }
    }

    public static <T extends Iterable<?>> T trimAllFields(T objects) {
        if (objects != null) {
            for (Object object : objects) {
                Reflection.trimAllFields(object);
            }
        }
        return objects;
    }
}

