/*
 * Decompiled with CFR 0.152.
 */
package ar.gabrielsuarez.glib.core;

import ar.gabrielsuarez.glib.G;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class XCrypto {
    public static String md2(String value) {
        return XCrypto.hash("MD2", value);
    }

    public static String md5(String value) {
        return XCrypto.hash("MD5", value);
    }

    public static String sha(String value) {
        return XCrypto.hash("SHA", value);
    }

    public static String sha224(String value) {
        return XCrypto.hash("SHA-224", value);
    }

    public static String sha256(String value) {
        return XCrypto.hash("SHA-256", value);
    }

    public static String sha384(String value) {
        return XCrypto.hash("SHA-384", value);
    }

    public static String sha512(String value) {
        return XCrypto.hash("SHA-512", value);
    }

    public static String sha512_244(String value) {
        return XCrypto.hash("SHA-512/224", value);
    }

    public static String sha512_256(String value) {
        return XCrypto.hash("SHA-512/256", value);
    }

    protected static List<String> hashAlgorithms() {
        Provider[] providers;
        ArrayList<String> list = new ArrayList<String>();
        for (Provider provider : providers = Security.getProviders()) {
            Set<Provider.Service> services = provider.getServices();
            for (Provider.Service service : services) {
                if (!MessageDigest.class.getSimpleName().equals(service.getType())) continue;
                list.add(service.getAlgorithm());
            }
        }
        return list;
    }

    protected static String hash(String algorithm, String value) {
        try {
            if (value != null) {
                MessageDigest md = MessageDigest.getInstance(algorithm);
                byte[] bytes = md.digest(value.getBytes());
                return G.toHex(bytes);
            }
            return null;
        }
        catch (Exception e) {
            throw G.runtimeException(e);
        }
    }
}

