/*
 * Decompiled with CFR 0.152.
 */
package ar.gabrielsuarez.glib.core;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Stream;

public abstract class XEnviroment {
    public static Boolean isWindows() {
        return System.getProperty("os.name", "generic").toLowerCase().contains("windows");
    }

    public static Boolean isJar() {
        return "jar".equalsIgnoreCase(Thread.currentThread().getContextClassLoader().getResource("").getProtocol());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Boolean isDocker() {
        try (Stream<String> stream = Files.lines(Paths.get("/proc/1/cgroup", new String[0]));){
            Boolean bl = stream.anyMatch(line -> line.contains("docker"));
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String desktopPath() {
        return new File(System.getProperty("user.home"), "Desktop").getAbsolutePath();
    }

    public static String desktopPath(String relativePath) {
        return new File(XEnviroment.desktopPath(), relativePath).getAbsolutePath();
    }

    public static String compiledPath() {
        return new File(Thread.currentThread().getContextClassLoader().getResource("").getPath()).getAbsolutePath();
    }

    public static String sourcePath() {
        return XEnviroment.sourcePath("src/main/java");
    }

    public static String sourcePath(String relativePath) {
        File currentPath = new File(XEnviroment.compiledPath());
        while (currentPath.getParentFile() != null) {
            HashSet<String> names;
            String[] currentPathList = (currentPath = currentPath.getParentFile()).list();
            if (currentPathList == null || !(names = new HashSet<String>(Arrays.asList(currentPathList))).contains("pom.xml") && !names.contains("build.gradle")) continue;
            return new File(currentPath.getAbsoluteFile(), relativePath).getAbsolutePath();
        }
        return null;
    }

    public static String resourcePath() {
        return XEnviroment.sourcePath("src/main/resources");
    }

    public static String tmpPath() {
        String tmp = System.getProperty("java.io.tmpdir");
        if (tmp == null || tmp.isEmpty()) {
            tmp = "/tmp";
        }
        return tmp;
    }
}

