/*
 * Decompiled with CFR 0.152.
 */
package ar.gabrielsuarez.glib.core;

import ar.gabrielsuarez.glib.G;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;

public abstract class XFile {
    public static Boolean fileExists(String path) {
        return new File(path).exists();
    }

    public static String readFile(String path) {
        try {
            return new String(Files.readAllBytes(Paths.get(path, new String[0])));
        }
        catch (Exception e) {
            throw G.runtimeException(e);
        }
    }

    public static File writeFile(String path, String content) {
        new File(path).getParentFile().mkdirs();
        try (PrintWriter printWriter = new PrintWriter(path);){
            printWriter.write(content);
        }
        catch (Exception e) {
            throw G.runtimeException(e);
        }
        return new File(path);
    }

    public static File writeFile(String basePath, String relativePath, String content) {
        String path = new File(basePath, relativePath).getAbsolutePath();
        return XFile.writeFile(path, content);
    }

    public static File writeFile(String path, byte[] content) {
        try (FileOutputStream fos = new FileOutputStream(path);){
            fos.write(content);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new File(path);
    }

    public static File writeFile(String basePath, String relativePath, byte[] content) {
        String path = new File(basePath, relativePath).getAbsolutePath();
        return XFile.writeFile(path, content);
    }
}

