/*
 * Decompiled with CFR 0.152.
 */
package ar.gabrielsuarez.glib.data;

import ar.gabrielsuarez.glib.G;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Data {
    public Map<String, Object> map;
    public List<Object> list;
    private Boolean caseSensitive;

    public Data() {
        this.convertToMap();
    }

    public static Data fromData(Data data) {
        return new Data().load(data.raw());
    }

    public static Data fromMap(Map<String, Object> map) {
        return new Data().loadMap(map);
    }

    public static Data fromList(Collection<? extends Object> list) {
        return new Data().loadList(list);
    }

    public static Data fromJson(String json) {
        return new Data().loadJson(json);
    }

    public static Data fromXml(String xml) {
        return new Data().loadXml(xml);
    }

    public static Data fromYaml(String yaml) {
        return new Data().loadYaml(yaml);
    }

    public static Data fromRawMap(Map<String, Object> map) {
        Data data = new Data();
        data.map = map;
        return data;
    }

    public static Data fromRawList(List<Object> list) {
        Data data = new Data();
        data.list = list;
        return data;
    }

    public Map<String, Object> convertToMap() {
        this.map = this.map == null ? new LinkedHashMap() : this.map;
        this.list = null;
        return this.map;
    }

    public List<Object> convertToList() {
        this.map = null;
        this.list = this.list == null ? new ArrayList() : this.list;
        return this.list;
    }

    public Data caseSensitive(Boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        return this;
    }

    public Data load(Object object) {
        if (object instanceof Map) {
            this.convertToMap().putAll((Map)object);
        }
        if (object instanceof Collection) {
            this.convertToList().addAll((Collection)object);
        }
        return this;
    }

    public Data loadData(Data data) {
        return this.load(data.raw());
    }

    public Data loadMap(Map<String, Object> map) {
        return this.load(map);
    }

    public Data loadList(Collection<? extends Object> list) {
        return this.load(list);
    }

    public Data loadJson(String json) {
        return this.load(json != null && !json.isEmpty() ? G.fromJson(json) : null);
    }

    public Data loadXml(String xml) {
        return this.load(xml != null && !xml.isEmpty() ? G.fromXml(xml) : null);
    }

    public Data loadYaml(String yaml) {
        return this.load(yaml != null && !yaml.isEmpty() ? G.fromYaml(yaml) : null);
    }

    public Map<String, Object> toMap() {
        return this.map != null ? new LinkedHashMap<String, Object>(this.map) : new LinkedHashMap();
    }

    public List<Object> toList() {
        return this.list != null ? new ArrayList<Object>(this.list) : new ArrayList();
    }

    public String toJson() {
        return G.toJson(this);
    }

    public String toJsonSingleLine() {
        return G.toJsonSingleLine(this);
    }

    public String toXml(String root) {
        return G.toXml(this, root);
    }

    public String toXmlSingleLine(String root) {
        return G.toXmlSingleLine(this, root);
    }

    public String toYaml() {
        return G.toYaml(this);
    }

    public <T> T toClass(Class<T> type) {
        return G.fromJson(this.toJson(), type);
    }

    public Object get(String key) {
        Data current = this;
        String[] subkeys = key.split("\\.");
        for (int i = 0; i < subkeys.length; ++i) {
            Data data = current = current instanceof Data ? current.raw() : current;
            if (current instanceof Map) {
                Map map = (Map)((Object)current);
                String subkey = subkeys[i];
                if (this.caseSensitive == null || this.caseSensitive.booleanValue()) {
                    current = map.get(subkey);
                    continue;
                }
                current = map.get(G.findFirst(map.keySet(), x -> x.equalsIgnoreCase(subkey)));
                continue;
            }
            if (current instanceof List) {
                List list = (List)((Object)current);
                Integer index = G.toInteger(subkeys[i]);
                current = index != null && list.size() > index && index >= 0 ? list.get(index) : null;
                continue;
            }
            current = null;
        }
        return current;
    }

    public Data set(String key) {
        Data data = new Data();
        this.set(key, data);
        return data;
    }

    public Data set(String key, Object value) {
        Data context = this;
        Data next = null;
        String[] subkeys = key.split("\\.");
        for (int i = 0; i < subkeys.length; ++i) {
            Object object = null;
            String subkey = subkeys[i];
            Integer index = G.toInteger(subkey);
            Boolean validIndex = index != null && index >= 0;
            Boolean isLast = i + 1 == subkeys.length;
            if (!validIndex.booleanValue()) {
                context.convertToMap();
                object = context.map.get(subkey);
            } else {
                context.convertToList();
                while (context.list.size() <= index) {
                    context.list.add(null);
                }
                object = context.list.get(index);
            }
            if (!isLast.booleanValue()) {
                if (object instanceof Data) {
                    next = (Data)object;
                } else if (object instanceof Map) {
                    next = Data.fromRawMap((Map)object);
                } else if (object instanceof List) {
                    next = Data.fromRawList((List)object);
                } else {
                    next = new Data();
                    object = validIndex == false ? context.map.put(subkey, next) : context.list.set(index, next);
                }
                context = next;
                continue;
            }
            object = validIndex == false ? context.map.put(subkey, value) : context.list.set(index, value);
        }
        return this;
    }

    public Data set(String key, Object value, Boolean condition) {
        if (condition.booleanValue()) {
            return this.set(key, value);
        }
        return this;
    }

    public Data add() {
        Data data = new Data();
        this.convertToList().add(data);
        return data;
    }

    public Data add(String key) {
        Data data = new Data();
        this.add(key, data);
        return data;
    }

    public Data add(Object value) {
        this.convertToList().add(value);
        return this;
    }

    public Data add(String key, Object value) {
        Data context = this;
        Data next = null;
        String[] subkeys = key.split("\\.");
        for (int i = 0; i < subkeys.length; ++i) {
            Object object = null;
            String subkey = subkeys[i];
            Integer index = G.toInteger(subkey);
            Boolean validIndex = index != null && index >= 0;
            if (!validIndex.booleanValue()) {
                context.convertToMap();
                object = context.map.get(subkey);
            } else {
                context.convertToList();
                while (context.list.size() <= index) {
                    context.list.add(null);
                }
                object = context.list.get(index);
            }
            if (object instanceof Data) {
                next = (Data)object;
            } else if (object instanceof Map) {
                next = Data.fromRawMap((Map)object);
            } else if (object instanceof List) {
                next = Data.fromRawList((List)object);
            } else {
                next = new Data();
                object = validIndex == false ? context.map.put(subkey, next) : context.list.set(index, next);
            }
            context = next;
        }
        context.convertToList().add(value);
        return this;
    }

    public Data add(String key, Object value, Boolean condition) {
        if (condition.booleanValue()) {
            return this.add(key, value);
        }
        return this;
    }

    public Data addValue(Object value) {
        this.convertToList().add(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Boolean remove(String key) {
        Data context = this;
        Data next = null;
        String[] subkeys = key.split("\\.");
        for (int i = 0; i < subkeys.length; ++i) {
            Object object = null;
            String subkey = subkeys[i];
            Integer index = G.toInteger(subkey);
            Boolean validIndex = index != null && index >= 0;
            Boolean isLast = i + 1 == subkeys.length;
            if (context.map != null) {
                object = context.map.get(subkey);
            } else if (context.list != null && validIndex.booleanValue()) {
                object = context.list.get(index);
            }
            if (!isLast.booleanValue()) {
                if (object instanceof Data) {
                    next = (Data)object;
                } else if (object instanceof Map) {
                    next = Data.fromRawMap((Map)object);
                } else {
                    if (!(object instanceof List)) return false;
                    next = Data.fromRawList((List)object);
                }
            } else {
                if (context.map != null) {
                    object = context.map.remove(subkey);
                    return object != null;
                }
                if (context.list == null || !validIndex.booleanValue()) return false;
                return context.list.remove(index);
            }
            context = next;
        }
        return false;
    }

    public Boolean remove(String key, Boolean condition) {
        if (condition.booleanValue()) {
            return this.remove(key);
        }
        return false;
    }

    public Object raw() {
        Object object = null;
        object = this.map != null ? this.map : object;
        object = this.list != null ? this.list : object;
        return object;
    }

    public Object object(String key) {
        return this.object(key, null);
    }

    public Object object(String key, Object defaultValue) {
        Object object = this.get(key);
        return object != null ? object : defaultValue;
    }

    public Data data(String key) {
        return this.data(key, null);
    }

    public Data data(String key, Data defaultValue) {
        Object object = this.object(key);
        if (object instanceof Data) {
            return (Data)object;
        }
        if (object instanceof Map) {
            return Data.fromMap((Map)object);
        }
        if (object instanceof Data) {
            return Data.fromList((List)object);
        }
        return defaultValue;
    }

    public List<Data> dataList() {
        Data data = this;
        ArrayList<Data> list = data.list != null ? data.list : new ArrayList<Data>();
        return list;
    }

    public List<Data> dataList(String key) {
        Data data = this.data(key);
        ArrayList<Data> list = data.list != null ? data.list : new ArrayList<Data>();
        return list;
    }

    public Map<String, Object> map(String key) {
        return this.map(key, null);
    }

    public Map<String, Object> map(String key, Map<String, Object> defaultValue) {
        Object object = this.object(key);
        if (object instanceof Data) {
            return ((Data)object).map;
        }
        if (object instanceof Map) {
            return (Map)object;
        }
        return defaultValue;
    }

    public List<Object> list(String key) {
        return this.list(key, null);
    }

    public List<Object> list(String key, List<Object> defaultValue) {
        Object object = this.object(key);
        if (object instanceof Data) {
            return ((Data)object).list;
        }
        if (object instanceof List) {
            return (List)object;
        }
        return defaultValue;
    }

    public String string(String key) {
        return this.string(key, null);
    }

    public String string(String key, String defaultValue) {
        Object object = this.object(key);
        return object != null ? object.toString() : defaultValue;
    }

    public Boolean bool(String key) {
        return this.bool(key, null);
    }

    public Boolean bool(String key, Boolean defaultValue) {
        return G.toBoolean(this.string(key), defaultValue);
    }

    public Short shortInt(String key) {
        return this.shortInt(key, null);
    }

    public Short shortInt(String key, Short defaultValue) {
        return G.toShort(this.string(key), defaultValue);
    }

    public Integer integer(String key) {
        return this.integer(key, null);
    }

    public Integer integer(String key, Integer defaultValue) {
        return G.toInteger(this.string(key), defaultValue);
    }

    public Long longInt(String key) {
        return this.longInt(key, null);
    }

    public Long longInt(String key, Long defaultValue) {
        return G.toLong(this.string(key), defaultValue);
    }

    public Float floatNumber(String key) {
        return this.floatNumber(key, null);
    }

    public Float floatNumber(String key, Float defaultValue) {
        return G.toFloat(this.string(key), defaultValue);
    }

    public Double doubleNumber(String key) {
        return this.doubleNumber(key, null);
    }

    public Double doubleNumber(String key, Double defaultValue) {
        return G.toDouble(this.string(key), defaultValue);
    }

    public BigInteger bigInteger(String key) {
        return this.bigInteger(key, null);
    }

    public BigInteger bigInteger(String key, BigInteger defaultValue) {
        return G.toBigInteger(this.string(key), defaultValue);
    }

    public BigDecimal bigDecimal(String key) {
        return this.bigDecimal(key, null);
    }

    public BigDecimal bigDecimal(String key, BigDecimal defaultValue) {
        return G.toBigDecimal(this.string(key), defaultValue);
    }

    public String toString() {
        return this.toJson();
    }
}

