/*
 * Decompiled with CFR 0.152.
 */
package ar.gabrielsuarez.glib.generator;

import ar.gabrielsuarez.glib.G;
import ar.gabrielsuarez.glib.sql.metadata.Catalog;
import ar.gabrielsuarez.glib.sql.metadata.Column;
import ar.gabrielsuarez.glib.sql.metadata.Table;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class JdbcGenerator {
    private Catalog catalog;
    public String catalogPackage;
    public String tablePackage;
    public String catalogName;
    public String prefixCatalogClassName = "Catalog";
    public String prefixTableClassName = "Table";
    public String prefixTableObjectName = "";
    public String prefixRowClassName = "Row";
    public String prefixRowObjectName = "row";
    public String tagTables = "TABLES";
    public String tagInstance = "INSTANCE";
    public String tagAttributes = "ATTRIBUTES";
    public String tagRow = "ROW";
    public Boolean replaceFiles = true;
    public Boolean printSource = true;
    public String basePath;

    public JdbcGenerator(Catalog catalog) {
        this.catalog = catalog;
    }

    protected JdbcCatalog jdbcCatalog() {
        JdbcCatalog jdbcCatalog = new JdbcCatalog();
        jdbcCatalog.catalogPackage = this.catalogPackage;
        jdbcCatalog.catalogClassName = this.prefixCatalogClassName + G.pascalCase(this.catalog.TABLE_CAT);
        jdbcCatalog.catalogImports.add("javax.sql.DataSource");
        HashSet<String> tables = new HashSet<String>();
        for (Table table : this.catalog.tables) {
            if (table.isSystemTable().booleanValue() || tables.contains(table.TABLE_NAME)) continue;
            JdbcTable jdbcTable = this.jdbcTable(table);
            jdbcCatalog.tables.add(jdbcTable);
            tables.add(table.TABLE_NAME);
            if (this.catalogPackage == null || this.catalogPackage.equals(this.tablePackage)) continue;
            jdbcCatalog.catalogImports.add(jdbcTable.tablesPackage + "." + jdbcTable.tableClassName);
        }
        return jdbcCatalog;
    }

    protected JdbcTable jdbcTable(Table table) {
        JdbcTable jdbcTable = new JdbcTable();
        jdbcTable.tablesPackage = this.tablePackage;
        jdbcTable.tableImports.add("ar.gabrielsuarez.glib.data.Base");
        jdbcTable.tableImports.add("ar.gabrielsuarez.glib.sql.SqlRequest");
        jdbcTable.tableImports.add("ar.gabrielsuarez.glib.sql.SqlResponse");
        jdbcTable.tableImports.add("java.util.List");
        jdbcTable.tableImports.add("javax.sql.DataSource");
        jdbcTable.tableClassName = this.prefixTableClassName + G.pascalCase(table.TABLE_NAME);
        jdbcTable.tableObjectName = this.prefixTableObjectName + G.camelCase(table.TABLE_NAME);
        jdbcTable.rowClassName = this.prefixRowClassName + G.pascalCase(table.TABLE_NAME);
        jdbcTable.rowObjectName = this.prefixRowObjectName + G.pascalCase(table.TABLE_NAME);
        jdbcTable.tableName = table.TABLE_NAME;
        jdbcTable.isView = table.isView();
        for (Column column : table.columns) {
            JdbcColumn jdbcColumn = this.jdbcColumn(column);
            G.add(jdbcTable.columns, jdbcColumn);
            G.add(jdbcTable.columnsKeys, jdbcColumn, table.isPrimaryKey(column));
            G.add(jdbcTable.columnsNoKeys, jdbcColumn, table.isPrimaryKey(column) == false);
            G.add(jdbcTable.columnsNoAutoIncrement, jdbcColumn, column.isAutoIncrement() == false);
        }
        return jdbcTable;
    }

    protected JdbcColumn jdbcColumn(Column column) {
        JdbcColumn jdbcColumn = new JdbcColumn();
        jdbcColumn.javaClass = this.javaType(column);
        jdbcColumn.javaName = column.COLUMN_NAME;
        jdbcColumn.columnName = column.COLUMN_NAME;
        return jdbcColumn;
    }

    public Map<String, String> generate() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        try {
            Handlebars handlebars = new Handlebars();
            handlebars.prettyPrint(true);
            Template jdbcCatalogTemplate = handlebars.compile("jdbc-generator/JdbcCatalog");
            Template jdbcTablesTemplate = handlebars.compile("jdbc-generator/JdbcTable");
            JdbcCatalog jdbcCatalog = this.jdbcCatalog();
            if (jdbcCatalog != null) {
                Map<String, Object> data = G.toMap(jdbcCatalog);
                data.putAll(G.toMap(this));
                String javaClass = jdbcCatalogTemplate.apply(data);
                String key = this.key(jdbcCatalog.catalogPackage, jdbcCatalog.catalogClassName);
                map.put(key, javaClass);
                if (this.printSource.booleanValue()) {
                    System.out.println(javaClass);
                }
                if (this.basePath != null) {
                    G.writeFile(this.basePath, key.replace('.', '/') + ".java", javaClass);
                }
            }
            for (JdbcTable jdbcTable : jdbcCatalog.tables) {
                Map<String, Object> data = G.toMap(jdbcTable);
                data.putAll(G.toMap(this));
                String javaClass = jdbcTablesTemplate.apply(data);
                String key = this.key(jdbcTable.tablesPackage, jdbcTable.tableClassName);
                map.put(key, javaClass);
                if (this.printSource.booleanValue()) {
                    System.out.println(javaClass);
                }
                if (this.basePath == null) continue;
                G.writeFile(this.basePath, key.replace('.', '/') + ".java", javaClass);
            }
        }
        catch (Exception e) {
            throw G.runtimeException(e);
        }
        return map;
    }

    protected String key(String fullPackage, String className) {
        if (fullPackage != null) {
            return fullPackage + "." + className;
        }
        return className;
    }

    protected String javaType(Column column) {
        String javaType = null;
        javaType = -7 == column.DATA_TYPE ? "Boolean" : javaType;
        javaType = -6 == column.DATA_TYPE ? "Byte" : javaType;
        javaType = 5 == column.DATA_TYPE ? "Short" : javaType;
        javaType = 4 == column.DATA_TYPE ? "Integer" : javaType;
        javaType = -5 == column.DATA_TYPE ? "java.math.BigInteger" : javaType;
        javaType = 6 == column.DATA_TYPE ? "java.math.BigDecimal" : javaType;
        javaType = 7 == column.DATA_TYPE ? "java.math.BigDecimal" : javaType;
        javaType = 8 == column.DATA_TYPE ? "java.math.BigDecimal" : javaType;
        javaType = 2 == column.DATA_TYPE ? "java.math.BigDecimal" : javaType;
        javaType = 3 == column.DATA_TYPE ? "java.math.BigDecimal" : javaType;
        javaType = 1 == column.DATA_TYPE ? "String" : javaType;
        javaType = 12 == column.DATA_TYPE ? "String" : javaType;
        javaType = -1 == column.DATA_TYPE ? "String" : javaType;
        javaType = 91 == column.DATA_TYPE ? "java.time.LocalDate" : javaType;
        javaType = 92 == column.DATA_TYPE ? "java.time.LocalTime" : javaType;
        javaType = 93 == column.DATA_TYPE ? "java.time.LocalDateTime" : javaType;
        javaType = -2 == column.DATA_TYPE ? "byte[]" : javaType;
        javaType = -3 == column.DATA_TYPE ? "byte[]" : javaType;
        javaType = -4 == column.DATA_TYPE ? "byte[]" : javaType;
        javaType = 0 == column.DATA_TYPE ? "Object" : javaType;
        javaType = 1111 == column.DATA_TYPE ? "Object" : javaType;
        javaType = 2000 == column.DATA_TYPE ? "Object" : javaType;
        javaType = 2001 == column.DATA_TYPE ? "Object" : javaType;
        javaType = 2002 == column.DATA_TYPE ? "Object" : javaType;
        javaType = 2003 == column.DATA_TYPE ? "Object" : javaType;
        javaType = 2004 == column.DATA_TYPE ? "byte[]" : javaType;
        javaType = 2005 == column.DATA_TYPE ? "byte[]" : javaType;
        javaType = 2006 == column.DATA_TYPE ? "Object" : javaType;
        javaType = 70 == column.DATA_TYPE ? "Object" : javaType;
        javaType = 16 == column.DATA_TYPE ? "Boolean" : javaType;
        javaType = -8 == column.DATA_TYPE ? "Object" : javaType;
        javaType = -15 == column.DATA_TYPE ? "String" : javaType;
        javaType = -9 == column.DATA_TYPE ? "String" : javaType;
        javaType = -16 == column.DATA_TYPE ? "String" : javaType;
        javaType = 2011 == column.DATA_TYPE ? "byte[]" : javaType;
        javaType = 2009 == column.DATA_TYPE ? "Object" : javaType;
        javaType = 2012 == column.DATA_TYPE ? "Object" : javaType;
        javaType = 2013 == column.DATA_TYPE ? "java.time.ZonedDateTime" : javaType;
        javaType = 2014 == column.DATA_TYPE ? "java.time.ZonedDateTime" : javaType;
        String string = javaType = "VARCHAR".equalsIgnoreCase(column.TYPE_NAME) ? "String" : javaType;
        if (javaType == null) {
            javaType = "Object";
        }
        return javaType;
    }

    public static class JdbcColumn {
        public String javaClass;
        public String javaName;
        public String columnName;
    }

    public static class JdbcTable {
        public String tablesPackage;
        public Set<String> tableImports = new TreeSet<String>();
        public String tableClassName;
        public String tableObjectName;
        public String rowClassName;
        public String rowObjectName;
        public String tableName;
        public Boolean isView;
        public List<JdbcColumn> columns = new ArrayList<JdbcColumn>();
        public List<JdbcColumn> columnsKeys = new ArrayList<JdbcColumn>();
        public List<JdbcColumn> columnsNoKeys = new ArrayList<JdbcColumn>();
        public List<JdbcColumn> columnsNoAutoIncrement = new ArrayList<JdbcColumn>();
    }

    public static class JdbcCatalog {
        public String catalogPackage;
        public Set<String> catalogImports = new TreeSet<String>();
        public String catalogClassName;
        public List<JdbcTable> tables = new ArrayList<JdbcTable>();
    }
}

