/*
 * Decompiled with CFR 0.152.
 */
package ar.gabrielsuarez.glib.sql;

import ar.gabrielsuarez.glib.G;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SqlResponse {
    private Map<String, List<Object>> data = new HashMap<String, List<Object>>();

    public static SqlResponse fromResultSet(ResultSet resultSet) {
        SqlResponse sqlResponse;
        block16: {
            sqlResponse = new SqlResponse();
            try {
                if (resultSet == null) break block16;
                try (ResultSet rs = resultSet;){
                    ResultSetMetaData rsmd = rs.getMetaData();
                    Integer size = rsmd.getColumnCount();
                    while (rs.next()) {
                        for (int i = 1; i <= size; ++i) {
                            String columnName = rsmd.getColumnLabel(i);
                            Object value = rs.getObject(i);
                            sqlResponse.put(columnName, value);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw G.runtimeException(e);
            }
        }
        return sqlResponse;
    }

    public static <T> List<T> toList(Class<T> type, ResultSet resultSet) {
        return SqlResponse.fromResultSet(resultSet).toList(type);
    }

    public static <T> T toClass(Class<T> type, ResultSet resultSet) {
        return SqlResponse.fromResultSet(resultSet).toClass(type);
    }

    public <T> List<T> toList(Class<T> type) {
        try {
            ArrayList<T> list = new ArrayList<T>();
            Map<Field, List<Object>> fields = this.fields(type);
            Integer i = 0;
            while (i < this.size()) {
                T instance = G.instance(type);
                for (Field field : fields.keySet()) {
                    Object value = fields.get(field).get(i);
                    try {
                        field.set(instance, value);
                    }
                    catch (IllegalArgumentException e) {
                        field.set(instance, G.cast(field.getType(), value));
                    }
                }
                list.add(instance);
                i = i + 1;
            }
            return list;
        }
        catch (Exception e) {
            throw G.runtimeException(e);
        }
    }

    public <T> T toClass(Class<T> type) {
        return this.toList(type).stream().findFirst().orElse(null);
    }

    protected void put(String key, Object value) {
        List<Object> list = this.data.get(key);
        if (list == null) {
            list = new ArrayList<Object>();
            this.data.put(key, list);
        }
        list.add(value);
    }

    protected Integer size() {
        Iterator<String> iterator = this.data.keySet().iterator();
        if (iterator.hasNext()) {
            String fieldName = iterator.next();
            return this.data.get(fieldName).size();
        }
        return 0;
    }

    protected <T> Map<Field, List<Object>> fields(Class<T> type) {
        HashMap<Field, List<Object>> fields = new HashMap<Field, List<Object>>();
        Map<String, Field> fieldMap = G.fieldMap(type);
        for (String fieldName : this.data.keySet()) {
            Field field = fieldMap.get(fieldName);
            if (field == null) continue;
            fields.put(field, this.data.get(fieldName));
        }
        return fields;
    }
}

