/*
 * Decompiled with CFR 0.152.
 */
package ar.gabrielsuarez.glib.sql.metadata;

import ar.gabrielsuarez.glib.G;
import ar.gabrielsuarez.glib.data.Base;
import ar.gabrielsuarez.glib.sql.SqlResponse;
import ar.gabrielsuarez.glib.sql.metadata.Catalog;
import ar.gabrielsuarez.glib.sql.metadata.Column;
import ar.gabrielsuarez.glib.sql.metadata.PrimaryKey;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;

public class Table
extends Base {
    public String TABLE_CAT;
    public String TABLE_SCHEM;
    public String TABLE_NAME;
    public String TABLE_TYPE;
    public String REMARKS;
    public String TYPE_CAT;
    public String TYPE_SCHEM;
    public String TYPE_NAME;
    public String SELF_REFERENCING_COL_NAME;
    public String REF_GENERATION;
    public List<PrimaryKey> primaryKeys = new ArrayList<PrimaryKey>();
    public List<Column> columns = new ArrayList<Column>();

    public static List<Table> load(DataSource dataSource, Catalog catalog) {
        List<Object> tables = new ArrayList();
        try (Connection connection = dataSource.getConnection();){
            DatabaseMetaData metadata = connection.getMetaData();
            tables = SqlResponse.toList(Table.class, metadata.getTables(catalog.TABLE_CAT, null, null, null));
            G.trimAllFields(tables);
            for (Table table : tables) {
                table.primaryKeys = PrimaryKey.load(dataSource, table);
                table.columns = Column.load(dataSource, table);
            }
        }
        catch (Exception e) {
            throw G.runtimeException(e);
        }
        return tables;
    }

    public Boolean isPrimaryKey(Column column) {
        for (PrimaryKey primaryKey : this.primaryKeys) {
            if (!primaryKey.COLUMN_NAME.equals(column.COLUMN_NAME)) continue;
            return true;
        }
        return false;
    }

    public Boolean isSystemTable() {
        Boolean isSystemTable = false;
        isSystemTable = isSystemTable | "SYSTEM TABLE".equalsIgnoreCase(this.TABLE_TYPE);
        isSystemTable = isSystemTable | "INFORMATION_SCHEMA".equalsIgnoreCase(this.TABLE_SCHEM);
        isSystemTable = isSystemTable | "sys".equalsIgnoreCase(this.TABLE_SCHEM);
        isSystemTable = isSystemTable | "sysdiagrams".equalsIgnoreCase(this.TABLE_NAME);
        isSystemTable = isSystemTable | this.TABLE_NAME.toLowerCase().startsWith("syncobj");
        return isSystemTable;
    }

    public Boolean isView() {
        return "VIEW".equals(this.TABLE_TYPE);
    }
}

