/*
 * Decompiled with CFR 0.152.
 */
package ar.gabrielsuarez.glib.web;

import ar.gabrielsuarez.glib.G;
import ar.gabrielsuarez.glib.data.Data;
import ar.gabrielsuarez.glib.web.WebContext;
import ar.gabrielsuarez.glib.web.WebServer;
import java.util.function.Function;
import spark.Request;
import spark.Response;
import spark.Route;

public abstract class WebApplication<T extends WebContext> {
    private WebServer server;
    private Class<T> contextType;

    protected abstract void endpoints();

    protected abstract void before(T var1);

    protected abstract void after(T var1);

    protected abstract void exception(T var1, Exception var2);

    protected abstract void ultimately(T var1);

    protected void all(String path, Function<T, Object> funcion) {
        this.get(path, funcion);
        this.post(path, funcion);
        this.put(path, funcion);
        this.patch(path, funcion);
        this.delete(path, funcion);
    }

    protected void get(String path, Function<T, Object> funcion) {
        this.server.get(path, this.handle(funcion));
    }

    protected void post(String path, Function<T, Object> funcion) {
        this.server.post(path, this.handle(funcion));
    }

    protected void put(String path, Function<T, Object> funcion) {
        this.server.put(path, this.handle(funcion));
    }

    protected void patch(String path, Function<T, Object> funcion) {
        this.server.patch(path, this.handle(funcion));
    }

    protected void delete(String path, Function<T, Object> funcion) {
        this.server.delete(path, this.handle(funcion));
    }

    protected void head(String path, Function<T, Object> funcion) {
        this.server.head(path, this.handle(funcion));
    }

    protected void trace(String path, Function<T, Object> funcion) {
        this.server.trace(path, this.handle(funcion));
    }

    protected void connect(String path, Function<T, Object> funcion) {
        this.server.connect(path, this.handle(funcion));
    }

    protected void options(String path, Function<T, Object> funcion) {
        this.server.options(path, this.handle(funcion));
    }

    void setServer(WebServer server) {
        this.server = server;
    }

    void setContextType(Class<T> contextType) {
        this.contextType = contextType;
    }

    private Route handle(final Function<T, Object> function) {
        Route route = new Route(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object handle(Request sparkRequest, Response sparkResponse) {
                WebContext context = (WebContext)G.instance(WebApplication.this.contextType);
                context.init(sparkRequest, sparkResponse);
                try {
                    WebApplication.this.before(context);
                    context.response.body = function.apply(context);
                    WebApplication.this.after(context);
                }
                catch (Exception e) {
                    context.response.httpCode = 500;
                    WebApplication.this.exception(context, e);
                }
                finally {
                    WebApplication.this.ultimately(context);
                }
                sparkResponse.status(context.response.httpCode.intValue());
                Object body = context.response.body;
                if (body instanceof Data) {
                    context.response.setContentType("application/json");
                }
                for (String header : context.response.headers.keySet()) {
                    sparkResponse.header(header, context.response.headers.get(header));
                }
                if (context.request.gzipEnabled().booleanValue()) {
                    sparkResponse.header("Content-Encoding", "gzip");
                }
                return body != null ? body : "";
            }
        };
        return route;
    }
}

