/*
 * Decompiled with CFR 0.152.
 */
package ar.gabrielsuarez.glib.web;

import ar.gabrielsuarez.glib.G;
import ar.gabrielsuarez.glib.data.Data;
import ar.gabrielsuarez.glib.data.DataFile;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.MultipartConfigElement;
import javax.servlet.http.Part;
import spark.Request;

public class WebParameters
extends Data {
    private Map<String, DataFile> files = new LinkedHashMap<String, DataFile>();
    public Boolean failOnNull = true;

    WebParameters init(Request request) {
        this.loadPath(request);
        this.loadQueryAndForm(request);
        this.loadBody(request);
        this.loadMultipart(request);
        return this;
    }

    private Boolean isMultipart(Request request) {
        String contentType = request.headers("Content-Type");
        return contentType != null && contentType.contains("multipart/form-data");
    }

    private void loadPath(Request request) {
        for (String pathParam : request.params().keySet()) {
            this.set(pathParam, request.params(pathParam));
        }
    }

    private void loadQueryAndForm(Request request) {
        for (String queryParam : request.queryParams()) {
            this.set(queryParam, request.queryParams(queryParam));
        }
    }

    private void loadBody(Request request) {
        if (!this.isMultipart(request).booleanValue()) {
            String body = request.body();
            try {
                if (G.likeJson(body).booleanValue()) {
                    this.loadJson(body);
                } else if (G.likeXml(body).booleanValue()) {
                    this.loadXml(body);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void loadMultipart(Request request) {
        try {
            if (this.isMultipart(request).booleanValue()) {
                request.attribute("org.eclipse.jetty.multipartConfig", (Object)new MultipartConfigElement(G.tmpPath()));
                for (Part part : request.raw().getParts()) {
                    String key = part.getName();
                    String fileName = part.getSubmittedFileName();
                    if (fileName == null) {
                        String value = G.toString(part.getInputStream());
                        this.set(key, value);
                        continue;
                    }
                    byte[] bytes = G.toBytes(part.getInputStream());
                    DataFile file = new DataFile(fileName, bytes);
                    this.files.put(key, file);
                }
            }
        }
        catch (Exception e) {
            throw G.runtimeException(e);
        }
    }

    public Set<String> files() {
        return this.files.keySet();
    }

    public DataFile file(String fileName) {
        return this.files.get(fileName);
    }

    public WebParameters setFile(DataFile file) {
        if (file != null && file.name != null) {
            this.files.put(file.name, file);
        }
        return this;
    }

    @Override
    public Object object(String key) {
        return WebParamterException.check(this.failOnNull, key, super.object(key, null));
    }

    @Override
    public Data data(String key) {
        return WebParamterException.check(this.failOnNull, key, super.data(key, null));
    }

    @Override
    public Map<String, Object> map(String key) {
        return WebParamterException.check(this.failOnNull, key, super.map(key, null));
    }

    @Override
    public List<Object> list(String key) {
        return WebParamterException.check(this.failOnNull, key, super.list(key, null));
    }

    @Override
    public String string(String key) {
        return WebParamterException.check(this.failOnNull, key, super.string(key, null));
    }

    @Override
    public Boolean bool(String key) {
        return WebParamterException.check(this.failOnNull, key, super.bool(key, null));
    }

    @Override
    public Short shortInt(String key) {
        return WebParamterException.check(this.failOnNull, key, super.shortInt(key, null));
    }

    @Override
    public Integer integer(String key) {
        return WebParamterException.check(this.failOnNull, key, super.integer(key, null));
    }

    @Override
    public Long longInt(String key) {
        return WebParamterException.check(this.failOnNull, key, super.longInt(key, null));
    }

    @Override
    public Float floatNumber(String key) {
        return WebParamterException.check(this.failOnNull, key, super.floatNumber(key, null));
    }

    @Override
    public Double doubleNumber(String key) {
        return WebParamterException.check(this.failOnNull, key, super.doubleNumber(key, null));
    }

    @Override
    public BigInteger bigInteger(String key) {
        return WebParamterException.check(this.failOnNull, key, super.bigInteger(key, null));
    }

    @Override
    public BigDecimal bigDecimal(String key) {
        return WebParamterException.check(this.failOnNull, key, super.bigDecimal(key, null));
    }

    @Override
    public String toString() {
        Data data = Data.fromData(this);
        for (String key : this.files.keySet()) {
            String value = "[binary:" + this.files.get((Object)key).bytes.length + "]";
            data.set(key, value);
        }
        return data.toString();
    }

    public static class WebParamterException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        public String key;
        public Object value;

        public WebParamterException(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public static <T> T check(Boolean failOnNull, String key, T value) {
            if (value == null && failOnNull.booleanValue()) {
                throw new WebParamterException(key, value);
            }
            return value;
        }
    }
}

